package across.util.skn.util.membership;

import across.util.skn.util.FuzzySet;

/**
 *  This is a base class for membership functions.
 *  It represents the degree of membership of the member in a set.
 *  Objects that are actually members are of the type MemberObject
 */
public abstract class Membership<MemberObject> implements Comparable, MembershipInterface
{
    // Reference to the member
    MemberObject member;
    // reference to the set
    FuzzySet set = null;

    /** Returns a reference to member */
    public MemberObject getMember() {
        return member;
    }
    /** Returns a reference to the set.*/
    public FuzzySet getSet() {
        return set;
    }

    /** Creates the membership object and adds it to the specified set */
    public Membership(MemberObject member, FuzzySet set) {
        this.member = member;
        this.set = set;
        if (null != set)
        {
            set.addMember(this);
        }
    }

    public Membership(MemberObject member) {
        this.member = member;
    }

    /** Removes the membership object from the current set and adds it to the new set. */
    public void setSet(FuzzySet set) {
        if (null != this.set)
        {
            this.set.removeMember(this);
        }
        this.set = set;
        set.addMember(this);
    }

    /**
     * @param o the Object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     *         is less than, equal to, or greater than the specified object.
     * @throws ClassCastException if the specified object's type prevents it
     *                            from being compared to this Object.
     */
    public abstract int compareTo(Object o);

    /**
     * Returns true if the value is based on sufficient ammount of data, False otherwise.
     * @return true if the ammount of data on which the trust is based is sufficient
     */
    public boolean hasEnoughData() {
        return true;
    }
}
