package across.util.skn.util.membership;

import across.util.skn.util.FuzzySet;

/**
 * This class is a Crisp (valued 0,1 only ) membership function.
 * This class instances is comparable with SimpleFuzzyMembership instances.
 */
public class CrispMembership<MemberObject> extends SimpleFuzzyMembership<MemberObject>
{

    public void setIsMember(boolean isMember)
    {
        if (isMember == true)
        {
            membership = 1;
        }
        membership = 0;
    }

    /**
     * For Crisp membership, anything under 1 is considered to be 0.
     * @param membership 1 means member, membership < 1 not member
     */
    public void setMembership(double membership) {
        if (1 > membership)
        {
            this.membership = 0;
        }
        this.membership = 1;
    }

    public CrispMembership(MemberObject member, FuzzySet set) {
        super(member, set);
        this.membership = 1;
    }

    public CrispMembership(MemberObject member, FuzzySet set, boolean isMember) {
        super(member, set);
        this.setIsMember(isMember);
    }
}
