package across.util.skn.plan.across;

//import across.skn.AgentKnowledge;
import java.util.List;

import across.util.skn.plan.Action;

public class AcTransport extends Action {
	
	protected String startNode;
	protected String targetNode;
	
	/** Relative cost of this action in the domain */
	double distanceEstimate = Double.MAX_VALUE;
	
	/**
	 * Creates a transport action.
	 * @param startNode
	 * @param targetNode
	 */
	public AcTransport(String startNode, String targetNode, double distance){//, AgentKnowledge startAgent, AgentKnowledge targetAgent) {
		super("TRANSPORT");
		this.startNode = startNode;
		this.targetNode = targetNode;
		distanceEstimate = distance;
	}

	/**
	 * Creates a transport action.
	 * @param startNode
	 * @param targetNode
	 */
	public AcTransport(String startNode, String targetNode){
		super("TRANSPORT");
		this.startNode = startNode;
		this.targetNode = targetNode;
	}
	
	
	public AcTransport(String actionType, String startNode, String targetNode, double distance) {
		super(actionType);
		this.startNode = startNode;
		this.targetNode = targetNode;
		distanceEstimate = distance;
	}
	
	/**
	 * @param actions
	 */
	public AcTransport(List<Action> actions) {
		super(actions);
		this.startNode = ((AcTransport)actions.get(0)).startNode;
		this.targetNode = ((AcTransport)actions.get(0)).targetNode;
	}

	/**
	 * @return Returns the startNode.
	 */
	public String getStartNode() {
		return startNode;
	}

	/**
	 * @return Returns the targetNode.
	 */
	public String getTargetNode() {
		return targetNode;
	}
	
	/**
	 * Prepares action descriptor. Used to identify semantically equivalent action.
	 * @return ActionDescriptor identifies uniquely the action semantics.
	 */
	@Override
	public String getActionDescriptor()
	{
		return createActionDescriptor(startNode, targetNode);
	}

	public static String createActionDescriptor(String startNode, String targetNode) {
		return "TRANSPORT " + startNode + " " + targetNode;
	}

	public double getDistanceEstimate() {
		if (distanceEstimate == Double.MAX_VALUE)
		{
			distanceEstimate = 0;
		}
		return distanceEstimate;
	}
}
