package across.util.skn.plan.across;

import across.data.TransportBatch;
import across.util.skn.plan.Commitment;
import across.util.skn.plan.ResourceKnowledge;
import across.util.skn.util.membership.SimpleFuzzyMembership;


/** Represents a commitment of one resource to transport the batch on a given trajectory */
public class AcTransCommitment extends Commitment {

	private TransportBatch batch;
	private ResourceKnowledge resource;

	public AcTransCommitment( ResourceKnowledge rk, TransportBatch tb) {
		super(rk.getResourceOwner());
		this.resource = rk;
		this.batch = tb;
	}

	@Override
	public SimpleFuzzyMembership getCompleted() {
		//TODO
		return null;
	}

	@Override
	public String toString() {
		return resource.getResourceID() + " Batch: " + batch.getBatchid() + " count: " + batch.getCount();
	}

	public TransportBatch getBatch() {
		return batch;
	}
	
	

}
