package across.util.skn.plan.across;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import across.data.TransportAction;
import across.data.TransportPlan;
import across.util.skn.plan.Action;
import across.util.skn.plan.PlanTemplate;
/**
 * Plan template is a graph of successive actions linking start and target objectives. 
 * It includes all possible actions and their combinations.
 */
public class AcPlanTemplate extends PlanTemplate {

	//ObGoodsStored startingStorage;
	//ObGoodsStored targetStorage;
	
	public AcPlanTemplate() {
		super();
		// TODO Auto-generated constructor stub
	}

	public AcPlanTemplate(TransportPlan tpxml) {
		super();
		loadFromXml(tpxml);
	}

	public AcPlanTemplate(Collection<AcTransport> actions, Collection<AcTransport> objectives) {
		super(actions, objectives);
		identifyPrersResults();
	}

	/** loads the plan from the XML element*/
	public void loadFromXml(TransportPlan tp)
	{
		//create the actions and objectives
		for (Iterator it = tp.getTransportAction().iterator(); it.hasNext();) {
			TransportAction ta = (TransportAction) it.next();
			if (ta.getActionType().equalsIgnoreCase("TRANSPORT"))
			{
				AcTransport acTransport = new AcTransport(ta.getStartLocation(), ta.getTargetLocation());
				actions.add(acTransport);
			}
			else if (ta.getActionType().equalsIgnoreCase("STORAGE"))
			{
				ObGoodsStored obgs = new ObGoodsStored(ta.getTargetLocation());
				objectives.add(obgs);
			}
		}
		
		// set the prerequisites between actions and objectives
		for (Iterator it = actions.iterator(); it.hasNext();) {
			AcTransport act = (AcTransport) it.next();
			// pass through the objectives and find a loading and unloading place
			for (Iterator it2 = objectives.iterator(); it2.hasNext();) {
				ObGoodsStored obj = (ObGoodsStored) it2.next();
				if (obj.getStorageNode().equalsIgnoreCase(act.getStartNode()))
				{
					act.addPrerequisite(obj);
					obj.addAllows(act);
				}
				else if (obj.getStorageNode().equalsIgnoreCase(act.getTargetNode()))
				{
					act.addAllows(obj);
					obj.addPrerequisite(act);
				}
			}
		}
		
		identifyPrersResults();
	}

	/**
	 * now identify the starting and achieved objectives
	 */
	private void identifyPrersResults() {
		for (Iterator it = objectives.iterator(); it.hasNext();) {
			AcTransport obj = (AcTransport) it.next();
			if (obj.isPlanStart())
			{
//				 it is one of the starts
				prerequisites.add(obj);
				
			}
			if (obj.isPlanTarget())
			{
//				 it is one of the objectives
				allows.add(obj);
			}
		}
	}
	
	/** Returns the actions that are common to both plans */ 
	public List<Action> getActionIntersection(AcPlanTemplate otherPlan)
	{
		LinkedList<Action> res = new LinkedList<Action>();
		
		for (Iterator it = actions.iterator(); it.hasNext();) {
			AcTransport act1 = (AcTransport) it.next();
			for (Iterator ito = otherPlan.actions.iterator(); ito.hasNext();) {
				AcTransport act2 = (AcTransport) ito.next();
				if (act1.equivalentTo(act2))
				{
					res.add(act1);
				}
			}
		}
		return res;
	}

	/* (non-Javadoc)
	 * @see across.skn.plan.Action#getActionDescriptor()
	 */
	@Override
	public String getActionDescriptor() {
		return getActionType() + hashCode();//TODO...
	}
	
	
	
	
}
