package across.util.skn.plan;

import java.util.List;

import across.util.skn.util.FuzzySet;
import across.util.skn.util.membership.CrispMembership;


/** ActionType holds information that is common to all actions with the same Action descriptor.
 * This is for example resource constraints, agent trustfulness and other domain dependent data.
 */
public class ActionType {

	/** Describes the type of the action - i.e. transport, storage,... */
	String actionDescriptor;
	
	/** Resources that may be allocated to this action. */
	FuzzySet<ResourceKnowledge> compatibleResources = new FuzzySet<ResourceKnowledge>();
	
	/**
	 * Creates the action type. Specifies the descriptor.
	 * @param descriptor
	 * @param cost relative action cost
	 */
	public ActionType(String descriptor) {
		super();
		actionDescriptor = descriptor;
	}
	
	/**
	 * Creates the action type. Specifies the descriptor.
	 * @param descriptor
	 */
	public ActionType(String descriptor, ResourceKnowledge compatibleResource) {
		super();
		actionDescriptor = descriptor;
		addCompatibleResource(compatibleResource);
	}

	public void addCompatibleResource(ResourceKnowledge compatibleResource) {
		if (! compatibleResources.containsMember(compatibleResource)){
			new CrispMembership<ResourceKnowledge>(compatibleResource, compatibleResources);
		}
	}

	public List<ResourceKnowledge> getCompatibleResourcesList() {
		return compatibleResources.getAllMembers();
	}
}
