package across.util.skn.listeners;

import across.util.skn.AgentKnowledge;

/**
 * This listener is implemented by social knowledge owners to receive callbacks when new agent (identified by unique name.)
 * becomes known to the agent for the first time.
 */
public interface NewAgentRegisteredListener
{
    /**
 * This method is called by social knowledge to notify its owner when new agent (identified by unique name.)
 * becomes known to the agent for the first time.
 */
    public void handleNewAgentRegistered(AgentKnowledge agent);
}
