package across.util.skn;

import java.util.Collection;

import across.util.skn.util.AgentSet;
import across.util.skn.util.membership.CrispMembership;
import aglobe.container.transport.Address;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 4.8.2004
 * Time: 16:30:41
 * To change this template use Options | File Templates.
 */
public class ServiceKnowledge extends AgentSet
{
    /** Name of the service provided */
    public String serviceName;

    /** Contains list of all interesting agents registered as providers of this service - one AgentKnowledge structure per agent.*/
    //public List serviceProviderList = new LinkedList();

    public ServiceKnowledge(String serviceName)
    {
        this.serviceName = serviceName;
    }

    public ServiceKnowledge(String service, AgentKnowledge agentKnowledge)
    {
        this.serviceName = service;
        addMember(agentKnowledge);
    }
    
    public void addMember(AgentKnowledge agentKnowledge)
    {
        new CrispMembership<AgentKnowledge>(agentKnowledge,this);
    }

    /** Returns a subset of providers, limited to those currently accessible to agent.\
     * @param doNotInclude address of the agent that is not included in the list even if it is present... typically the caller.
     * @return List containing addresses of accessible agents.*/
    public Collection<Address> getAccessibleProviders(Address doNotInclude)
    {
        return getAllAccessibleAgentsAddress(doNotInclude); 
    };
}
