package across.util.skn;

import across.util.skn.util.AgentSet;


/**
 This class holds an information about given alliance, includeing references to member agents.
 */
public class AllianceKnowledge extends AgentSet
{
    /** name of the alliance*/
    protected String name;

    protected SocialSubject socSubj;

    public AllianceKnowledge(String allianceName)
    {
        name = allianceName;
    }

    /**
     * Returns the name of the alliance.
     * @return Scenario - unique alliance name
     */
    public String getName() {
        return name;
    }
    /**
     * Returns alliance's social subject structure.
     * @return Social Subject structure
     */
    public SocialSubject getSocSubj() {
        return socSubj;
    }

    /**
     * Returns true if given entity is accessible, false if not. We consider the groups of agents to
     * be accessible if at least one member is accessible.
     *
     * @return true if accessible, false if not
     */
    public boolean isAccessible() {
        return true;  //TODO - implement this, not used for now
    }

}
