package across.util.pathfinding;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import across.agents.driver.data.NodeValue;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.data.Arc;
import across.data.Node;
import across.data.Waypoint;

public class AStarModPathfinding implements Pathfinding{
	 /** List of map locations - their indexes are the indexes in the roads field */
	 private List<Node> acrossMapNodes;
	 
	 /** Info for the map roads */
	 private List<Arc> acrossMapArcs;
	 
	 /** Counts cost for differet agents, e.g. every agent has own one*/
	 private RoadEvaluator roadEvaluator;
	 
	 /** Stores map of connections between each node*/
	 private Arc[][] arcsBetweenNodes;
	 
	 /** Stores indexes and names of nodes*/
	 private Map<Integer,Node> nodesByIndex = new HashMap<Integer,Node>(); 
	
	 /** Target location index in hashTable*/
	 private int toIndex;
	 
	 /** Starting location index in hashTable*/
	 private int fromIndex;
	 
	 /** Distances between nodes - the euclidean distance. */
	 private double[][] distances;
	 
	 /** Roads that are not passable. */
	 private List<Arc> barredRoads;
	 
	 public AStarModPathfinding(List<Node> acrossMapNodes, List<Arc> acrossMapArcs,double[][] acrossMapDistances, RoadEvaluator re, List<Arc> barredRoads) {
		 	this.acrossMapNodes = acrossMapNodes;
			this.acrossMapArcs = acrossMapArcs;
			this.roadEvaluator = re;
			this.distances = acrossMapDistances;
			this.arcsBetweenNodes = new Arc[acrossMapNodes.size()][acrossMapNodes.size()];
			this.barredRoads = barredRoads;
			
			/** inverted table for hashTable */
			Map<String,Integer> indexesOfNodes = new HashMap<String,Integer>();
				
			
			//	filling the table
			 for (Node nod : acrossMapNodes) {
				this.nodesByIndex.put(acrossMapNodes.indexOf(nod), nod);
				indexesOfNodes.put(nod.getName(), acrossMapNodes.indexOf(nod));
				this.arcsBetweenNodes[acrossMapNodes.indexOf(nod)][acrossMapNodes.indexOf(nod)] = null;
			 }	
			 
			 for (Arc arc : acrossMapArcs){
				 Integer i = (Integer) indexesOfNodes.get(arc.getFrom());
				 Integer j = (Integer) indexesOfNodes.get(arc.getTo());
				 this.arcsBetweenNodes[i][j] = arc;
				 this.arcsBetweenNodes[j][i] = arc;
			 }
			 
			 
		 }
	 
	  
	 public Route planRoute(String from, String to, double weightTime, double weightPrice) {
		 		 
		 Route route = new Route();
		 
		 //if we are looking for route to the same poit where we are standing
		 if (from.equalsIgnoreCase(to)){
			 Waypoint wp = new Waypoint(from);
			 route.addWaypoint(wp);
			 RouteInfo routeInfo = new RouteInfo(0, 0);
		     route.setRouteInfo(routeInfo);
		     return route;
		 }
		 
		 //resolving the indexes of from and to
		 int x = 0;
		 fromIndex = 0;
		 toIndex = 0;
		 for (Node nod : acrossMapNodes) {
			if (nod.getName().equalsIgnoreCase(from)) {
				fromIndex = x;
			}
			if (nod.getName().equalsIgnoreCase(to)){
				toIndex = x;
			}
			x++;
		}
		 
		 
	 	 
		 // set of open nodes
		 LinkedList<NodeValue> open = new LinkedList<NodeValue>();     
        // set of closed nodes
		 LinkedList<NodeValue> closed = new LinkedList<NodeValue>();    
		 // final road for return
		
		 //close first node
		 NodeValue nodval = new NodeValue(fromIndex);
		 closed.add(nodval);
		 
		 
		 //set first childs to open
		 for (int i = 0; i < acrossMapNodes.size(); i++) {
			 //	if direct road between them exists add him to open and set parent
			 Arc arcBetweenNodes = arcsBetweenNodes[i][fromIndex];
			 if (arcBetweenNodes != null && !barredRoads.contains(arcBetweenNodes)){
			 	NodeValue target = new NodeValue(i);
				target.previous = fromIndex;
				//TODO count heuristic
				target.setValue(weightPrice*roadEvaluator.getPrice(arcsBetweenNodes[i][fromIndex]) + 
						weightTime*roadEvaluator.getTime(arcsBetweenNodes[i][fromIndex]) +
						this.getNodeHeuristicValue(i));
				open.add(target);
			}
		}
		 
		 
		 // loop till we can move somewhere
		 while (open.size()>0) {
			
			// cheapest node in open search 
			NodeValue minVal = (NodeValue) open.getFirst();
			for (NodeValue node : open) {
			      if ( (minVal.getValue() == -1) || ( (node.getValue() >= 0) && (node.getValue() < minVal.getValue()) ) ) {
		        	minVal = node;
		        }
		      }
//			 if we are at the target node - compose the route and return it
			if(minVal.nodeIndex == toIndex){
				// if we are at the target node - compose the route and return it
				LinkedList<Waypoint> wplist = new LinkedList<Waypoint>();
		    	wplist.add(new Waypoint(acrossMapNodes.get(toIndex).getName()));
		    	
		        NodeValue node = minVal;
		        double time = 0;
		        double price = 0;
		        while(node.previous != -1){
		          price+=roadEvaluator.getPrice(arcsBetweenNodes[node.getNodeIndex()][node.getPrevious()]);
		          time+=roadEvaluator.getTime(arcsBetweenNodes[node.getNodeIndex()][node.getPrevious()]);
		          // if this is not the first node add to wplist
		          if ((acrossMapNodes.get(node.previous)) != acrossMapNodes.get(fromIndex)) {
		        	  wplist.addFirst(new Waypoint(acrossMapNodes.get(node.getPrevious()).getName()));
		          }
		          // look for node whose index is same as node.previous
		          for (NodeValue value : closed) {
		            if (value.getNodeIndex() == node.getPrevious()) node = value;
		          }
		        }
		        route.addWaypoints(wplist);
		        RouteInfo routeInfo = new RouteInfo(time, price);
		        route.setRouteInfo(routeInfo);
		        return route;
			}
			
			//search for childs 
			for (int i = 0; i < acrossMapNodes.size(); i++) {
				Arc arc = null;
				if (arcsBetweenNodes[i][minVal.getNodeIndex()]!=null){
					arc = arcsBetweenNodes[i][minVal.getNodeIndex()];
					
				}else{
					continue;
				}
				//test if child is in closed
				boolean nodeclosed = false;
				for (NodeValue node : closed) {
					if (i == node.nodeIndex) {
						nodeclosed = true;
					}
				}
				if (nodeclosed) {continue;}// search for another node
				
				//if child is in open, using nodeclosed for condition
				nodeclosed = false;
				NodeValue openNode = null;
				for (NodeValue node : open){
					if (i == node.nodeIndex){
						nodeclosed =true;
						openNode = node;
					}
				}
				//is in open
				if (nodeclosed) {
					//count matching value
					double value = minVal.value 
					+ weightPrice*roadEvaluator.getPrice(arc) 
					+ weightTime*roadEvaluator.getTime(arc) 
					+ this.getNodeHeuristicValue(i);
					//compare cost of both ways
					if (value < openNode.value){
						openNode.value = value;
						openNode.previous = minVal.nodeIndex;
					}
					
				//is not in open nor closed	
				} else {
					NodeValue target = new NodeValue(i);
					target.previous = minVal.nodeIndex;
					//TODO count heuristic
					target.setValue(minVal.value 
							+ weightPrice*roadEvaluator.getPrice(arc) 
							+ weightTime*roadEvaluator.getTime(arc) 
							+ this.getNodeHeuristicValue(i));
					open.add(target);
				}
				
			}//end of possible road
			//end of searching all nodes
			
			//move curent node to closed
			open.remove(minVal);
			closed.add(minVal);
			
			
		}//end while
		 
		return null;
	}
	
	 /**
	  * calculates the distance between node with index i in nodemap and target node
	  * @param i - actual node
	  * @return distance between them
	  */
	 private double getNodeHeuristicValue(int i){
		
		return distances[toIndex][i]; //Point3d.distanceXY(acrossMapNodes.get(this.toIndex).getX(),acrossMapNodes.get(this.toIndex).getY(),0,((Node)hashTable.get(i)).getX(),((Node)hashTable.get(i)).getY(),0);
			 
			 
		 }
 

}
