package across.util.ixplanparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This is the knowledge for the IX->Across plan parser.  It specifies which resources in
 * the IX plan are materials and which are vehicles and also which material is transported
 * by which vehicle.
 * @author Eduard Semsch
 *
 */
public class ParserKnowledge {
	
	protected List<String> vehicles = new ArrayList<String>();
	
	/** Activities where we pick up something first then transport it and then use it. */
	protected List<String> pickupMaterials = new ArrayList<String>();
	
	/** Activities where we have something then transport it and then drop it. */
	protected List<String> dropMaterials = new ArrayList<String>();
	
	protected Map<String,List<String>> whichVehicleTransportWhichMaterial = new HashMap<String, List<String>>();
	
	protected Map<String,String> templatePlaces = new HashMap<String, String>();

	public List<String> getVehicles() {
		return vehicles;
	}

	public void setVehicles(List<String> vehicles) {
		this.vehicles = vehicles;
	}

	public Map<String, List<String>> getWhichVehicleTransportWhichMaterial() {
		return whichVehicleTransportWhichMaterial;
	}

	public void setWhichVehicleTransportWhichMaterial(
			Map<String, List<String>> whichVehicleTransportWhichMaterial) {
		this.whichVehicleTransportWhichMaterial = whichVehicleTransportWhichMaterial;
	}

	public List<String> getDropMaterials() {
		return dropMaterials;
	}

	public void setDropMaterials(List<String> dropMaterials) {
		this.dropMaterials = dropMaterials;
	}

	public List<String> getPickupMaterials() {
		return pickupMaterials;
	}

	public void setPickupMaterials(List<String> pickupMaterials) {
		this.pickupMaterials = pickupMaterials;
	}

	public Map<String, String> getTemplatePlaces() {
		return templatePlaces;
	}

	public void setTemplatePlaces(Map<String, String> templatePlace) {
		this.templatePlaces = templatePlace;
	} 
	
}
