package across.util;

import across.data.Param;
import aglobe.ontology.AglobeParam;

/**
 * <p>Title: XML Tools</p>
 * <p>Description: This class contains static utility methods for XML marshaling and unmarshaling.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Gerstner Laboratory</p>
 * @author David Sislak
 * @version $Revision: 1.2 $ $Date: 2007/01/26 12:37:21 $
 *
 */

public class XMLtools
{
  private XMLtools() {

  }

  /**
   * Make across.data.interlingua param structure with filled name and value atribute
   * @param name String
   * @param value String
   * @return Param
   */
  public static Param makeParam(String name, String value)
  {
    Param p= new Param();
    p.setName(name);
    p.setValue(value);
    return p;
  }

  /**
   * Make aglobe.ontology.AglobeParam structure with filled name and value atribute
   * @param name String
   * @param value String
   * @return Param
   */
  public static AglobeParam makeAglobeParam(String name, String value)
  {
    AglobeParam p= new AglobeParam();
    p.setName(name);
    p.setValue(value);
    return p;
  }

  /**
   * Convert across.data.interlingua.Param to the aglobe.ontology.AglobeParam
   * @param p Param
   * @return AglobeParam
   */
  public static AglobeParam convertParamToAglobeParam(Param p) {
    AglobeParam retVal = new AglobeParam();
    retVal.setName(p.getName());
    retVal.setValue(p.getValue());
    return retVal;
  }

  /**
   * Convert across.data.interlingua.AglobeParam to the aglobe.ontology.Param
   * @param p Param
   * @return AglobeParam
   */
  public static Param convertAglobeParamToParam(AglobeParam p) {
    Param retVal = new Param();
    retVal.setName(p.getName());
    retVal.setValue(p.getValue());
    return retVal;
  }
}
