package across.util;

import java.util.Collection;

import across.data.AdvTeamProposal;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import aglobe.container.transport.Address;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 22.7.2004
 * Time: 11:18:37
 * To change this template use Options | File Templates.
 */
public class ListBatchTools
{
    /**
     * Returns a copy of the transport batch pased in as an original.
     * @param original original batch
     * @return TransportBatch, null if original is null
     */
    public static TransportBatch copyTransportBatch(final TransportBatch original)
    {
        if (null != original)
        {
            return copyTransportBatch(original, original.getCount());
        }
        return null;
    }

    /**
     * Returns a copy of the transport batch pased in as an original, except that the count b=value is the one pased in newCount
     * @param original original batch
     * @param newCount count to use for the new batch
     * @return TransportBatch, null if original is null
     */
    public static TransportBatch copyTransportBatch(final TransportBatch original, long newCount)
    {
        if (null != original)
        {
            TransportBatch ntb = new TransportBatch();
            ntb.setBatchid(original.getBatchid());
            ntb.setComodityName(original.getComodityName());
            ntb.setCount(newCount);
            ntb.setStart(original.getStart());
            ntb.setStartAddress(original.getStartAddress());
            ntb.setStartTime(original.getStartTime());
            ntb.setTarget(original.getTarget());
            ntb.setTargetAddress(original.getTargetAddress());
            ntb.setTargetTime(original.getTargetTime());
            return ntb;
        }
        return null;
    }
    
    /**
     * Returns a copy of the transport batch pased in as an original, except that the count b=value is the one pased in newCount and start and target are modified to new values...
     * @param original original batch
     * @param newCount count to use for the new batch
     * @return TransportBatch, null if original is null
     */
    public static TransportBatch copyTransportBatch(final TransportBatch original, long newCount, String start, Address startAddress, String target, Address targetAddress)
    {
        if (null != original)
        {
            TransportBatch ntb = new TransportBatch();
            ntb.setBatchid(original.getBatchid());
            ntb.setComodityName(original.getComodityName());
            ntb.setCount(newCount);
            ntb.setStart(start);
            ntb.setStartAddress(startAddress);
            ntb.setStartTime(original.getStartTime());
            ntb.setTarget(target);
            ntb.setTargetAddress(targetAddress);
            ntb.setTargetTime(original.getTargetTime());
            return ntb;
        }
        return null;
    }
    
    /**
     * Returns a copy of the transport batch pased in as an original, except that the start and target are modified to new values...
     * @param original original batch
     * @return TransportBatch, null if original is null
     */
    public static TransportBatch copyTransportBatch(final TransportBatch original, String start, Address startAddress, long startTime, String target, Address targetAddress, long targetTime)
    {
        if (null != original)
        {
            TransportBatch ntb = new TransportBatch();
            ntb.setBatchid(original.getBatchid());
            ntb.setComodityName(original.getComodityName());
            ntb.setCount(original.getCount());
            ntb.setStart(start);
            ntb.setStartAddress(startAddress);
            ntb.setStartTime(startTime);
            ntb.setTarget(target);
            ntb.setTargetAddress(targetAddress);
            ntb.setTargetTime(targetTime);
            return ntb;
        }
        return null;
    }

    /**
     * Returns a copy of the transport batch pased in as an original, except that the start and target are modified to new values...
     * @param original original batch
     * @return TransportBatch, null if original is null
     */
    public static TransportBatch copyTransportBatch(final TransportBatch original, String start, Address startAddress, String target, Address targetAddress)
    {
        if (null != original)
        {
            return copyTransportBatch(original, original.getCount(), start, startAddress, target, targetAddress);
        }
        return null;
    }
    
    /**
     * Returns the total count of all the batches in the list 
     * @param batches list to count
     * @return total count, sum of all batches in the list regardless of the type
     */
    public static long getTotalCount(Collection<TransportBatch> batches)
    {
    	long res = 0;
    	for (TransportBatch batch : batches) {
			res += batch.getCount();
		}
    	return res;
    }
    
    /**
     * Returns the total count of all the batches with the given type in the list 
     * @param batches list to count
     * @param type type that we count - LIQUID, POWDER,... 
     * @return total count, sum of all batches in the list regardless of the type
     */
    public static long getTypeCount(Collection<TransportBatch> batches, String type)
    {
    	long res = 0;
    	for (TransportBatch batch : batches) {
			
    		if (GoodsConstants.resolveType(batch.getComodityName()).equalsIgnoreCase(type)) {
				res += batch.getCount();
			}
    	}
    	return res;
    }

    /**
     * Returns the start location of given TransportCfp. It assumes that all batches have same 
     * start location, so it is taken from the first batch.
     * @param tcpf TransportCfp
     * @return start location, null if TransportCfp does not include any TransportBatch
     */
    public static String getTransportCfpStart(TransportCfp tcpf)
    {
    	if (tcpf.getTransportBatch().size()>0) {
    		return ((TransportBatch)(tcpf.getTransportBatch().get(0))).getStart();
    	}
    	else
    		return null;
    }
    
    /**
     * Returns the target location of given TransportCfp. It assumes that all batches have same 
     * target location, so it is taken from the first batch.
     * @param tcpf TransportCfp
     * @return target location, null if TransportCfp does not include any TransportBatch
     */
    public static String getTransportCfpTarget(TransportCfp tcpf)
    {
    	if (tcpf.getTransportBatch().size()>0) {
    		return ((TransportBatch)(tcpf.getTransportBatch().get(0))).getTarget();
    	}
    	else
    		return null;
    }
    
    /**
     * Returns the TransportCfp id of given AdvTeamProposal. It assumes that contains at least
     * one TransportBatch, so it is taken from the first one.
     * @param atp AdvTeamProposal
     * @return Tcfp id, null if AdvTeamProposal does not include any TeamProposal
     */
    public static String getTransportCfpId(AdvTeamProposal atp)
    {
    	if (atp.getTask().size()>0) {
    		return ((TeamProposal)atp.getTask().get(0)).getTransportCfp().getRequestid();
    	}
    	else
    		return null;
    }
}