package across.util;

import java.util.HashMap;
import java.util.Map;

import across.data.Resource;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 27.5.2004
 * Time: 13:16:53
 * To change this template use Options | File Templates.
 */


/**
 * Contains denominations of all goods that may be traded between location agents.
 */
public class GoodsConstants
{
    public static final String WATER = "water";
    public static final String GRAIN = "grain";
    public static final String BREAD = "bread";
    public static final String FISH = "fish";
    public static final String SHEEP = "sheep";
    public static final String FLOUR = "flour";
    // CHANGED BY EDUARD SEMSCH ON Nov 2, 2006
    public static final String DOCTORS = "doctors";
    public static final String MEDICAL_MATERIAL = "medical material";
    public static final String WOUNDED_PERSONS = "wounded person";
    public static final String HEALED_PERSONS = "healed person";
    
    public static final int NUMBER_OF_GOODS = 10;
    // END OF CHANGE BY EDUARD SEMSCH ON Nov 2, 2006

    public static final int WATER_PRICE = 1;
    public static final int GRAIN_PRICE = 20;
    public static final int BREAD_PRICE = 3;
    public static final int FISH_PRICE = 8;
    public static final int SHEEP_PRICE = 50;
    public static final int FLOUR_PRICE = 15;
    // CHANGED BY EDUARD SEMSCH ON Nov 2, 2006
    public static final int DOCTORS_PRICE = 20;
    public static final int HEALED_PERSONS_PRICE = 10;
    public static final int WOUNDED_PERSONS_PRICE = 0;
    public static final int MEDICAL_MATERIAL_PRICE = 10;
    // END OF CHANGE BY EDUARD SEMSCH ON Nov 2, 2006

    public static final String TYPE_BOXED = "boxed";
    public static final String TYPE_POWDER = "powder";
    public static final String TYPE_LIQUID = "liquid";
    // CHANGED BY EDUARD SEMSCH ON Nov 2, 2006
    public static final String TYPE_AMBULANCE = "ambulance";
    public static final String TYPE_NOT_MOVEABLE = "not moveable";
    //public static final String TYPE_ANIMAL = "animal"; // use it later, if we need more types. so far we slaughter or box them before sending

    public static final String[] TYPES = {TYPE_BOXED, TYPE_LIQUID, TYPE_POWDER,TYPE_AMBULANCE,TYPE_NOT_MOVEABLE};

    /** This field contains one commodity per type */
    public static final String[] TYPES_EXAMPLES = {WATER, GRAIN, FISH, DOCTORS,WOUNDED_PERSONS};
    // END OF CHANGE BY EDUARD SEMSCH ON Nov 2, 2006
    /**
     * Resolves cargo type for given commodity.
     * @param commodityName name of the commodity
     * @return cargo type for given commodity. Returns Boxed for unknown commodities.
     */
    public static String resolveType(String commodityName)
    {
        if (commodityName.equalsIgnoreCase(WATER))
        {
            return TYPE_LIQUID;
        }
        else if (commodityName.equalsIgnoreCase(GRAIN) || commodityName.equalsIgnoreCase(FLOUR))
        {
            return TYPE_POWDER;
        } else if (commodityName.equalsIgnoreCase(DOCTORS) || commodityName.equalsIgnoreCase(HEALED_PERSONS)) {
        	return TYPE_AMBULANCE;
        } else if (commodityName.equalsIgnoreCase(WOUNDED_PERSONS)) {
        	return TYPE_NOT_MOVEABLE;
        }
        else return TYPE_BOXED;
    }
    
    /**
     * Resolves cargo type for given commodity.
     * @param commodityName name of the commodity
     * @return cargo type for given commodity. Returns Boxed for unknown commodities.
     */
    public static byte getTypeIndex(String typeName)
    {
        if (typeName.equalsIgnoreCase(TYPE_BOXED))
        {
            return 0;
        }
        if (typeName.equalsIgnoreCase(TYPE_LIQUID))
        {
            return 1;
        }
        if(typeName.equalsIgnoreCase(TYPE_AMBULANCE)) {
        	return 3;
        }
        if(typeName.equalsIgnoreCase(TYPE_NOT_MOVEABLE)) {
        	return 4;
        }
        return 2;
    }

    /**
     * Returns price for 1 unit of the given commodity
     * @param commodityName name of the commodity
     * @return price of the commodity or 0 if unknown
     */
    public static int getCommodityPrice(String commodityName) {
      if (commodityName.equalsIgnoreCase(WATER)) return WATER_PRICE;
      if (commodityName.equalsIgnoreCase(GRAIN)) return GRAIN_PRICE;
      if (commodityName.equalsIgnoreCase(BREAD)) return BREAD_PRICE;
      if (commodityName.equalsIgnoreCase(FISH)) return FISH_PRICE;
      if (commodityName.equalsIgnoreCase(SHEEP)) return SHEEP_PRICE;
      if (commodityName.equalsIgnoreCase(FLOUR)) return FLOUR_PRICE;
      if (commodityName.equalsIgnoreCase(DOCTORS)) return DOCTORS_PRICE;
   	  if (commodityName.equalsIgnoreCase(HEALED_PERSONS)) return HEALED_PERSONS_PRICE;
   	  if (commodityName.equalsIgnoreCase(MEDICAL_MATERIAL)) return MEDICAL_MATERIAL_PRICE;
      return 0;
    }

    /**
     * Returns a Map with Resource objects, one per each type of cargo.
     * @return Resource objects in a Map with 0 capacity.
     */
    public static Map<String,Resource> getCargoTypesResourceMap() {
        Map<String,Resource> map = new HashMap<String,Resource>();
        for (int i = 0; i < TYPES.length; i++)
        {
            String type = TYPES[i];
            Resource res = new Resource();
            res.setType(type);
            res.setCapacity(0);
            map.put(type, res);
        }
        return map;
    }
}
