package across.simulation.weather;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

import across.visio.visual.MyTreeCellRenderer;

/**
 * <p>Title: Weather Agent GUI</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author Pavel Jiranek
 * @version 1.0
 */

/**
 * This is GUI for the weather agent. 
 */
public class WeatherAgentGUI extends JFrame{

	GridBagLayout gridBagLayout1 = new GridBagLayout();
	private WeatherAgent owner;
	
	JButton jButton1 = new JButton();
	JTabbedPane jTabbedPane1 = new JTabbedPane();
	JScrollPane jScrollPane1 = new JScrollPane();	
	JTextArea jTextArea1 = new JTextArea();
	
	public WeatherAgentGUI(WeatherAgent _owner){
	    try {
	        owner = _owner;
	       Init();
	     }
	     catch(Exception e) {
	       e.printStackTrace();
	     }
	}
	private void Init()throws Exception{
		
	    this.getContentPane().setLayout(gridBagLayout1);
	    this.addWindowListener(new WeatherAgentGUI2_this_windowAdapter(this));
	    this.addWindowListener(new WeatherAgentGUI2_this_windowAdapter(this));
	    
	    jButton1.setText("kill me");
	    jButton1.addActionListener(new WeatherAgentGUI2_jButton1_actionAdapter(this));
	    jButton1.setIcon(new ImageIcon(MyTreeCellRenderer.class.getResource("images/disaster.gif")));
	    
	    jTextArea1.setText("Weather observatory...\n");
	    
	    this.getContentPane().add(jTabbedPane1,
                new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, GridBagConstraints.SOUTH, 
                		GridBagConstraints.NONE, new Insets(0, 0, 7, 1), 251, 134));
	    jTabbedPane1.add(jScrollPane1, "log");
	    jScrollPane1.getViewport().add(jTextArea1, null);

	    this.getContentPane().add(jButton1,    new GridBagConstraints(0, 6, 1, 2, 0.0, 0.0
	            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(-1, 0, 8, 0), 0, 0));
	    
	}
	
	void jButton1_actionPerformed(ActionEvent e) {
	    owner.killPressed();
	}
	public void log(String text) {
		if(jTextArea1.getText().length()>5000) {
			jTextArea1.setText("");
		}
	    jTextArea1.append(text+"\n");
	}
	
	void this_windowClosing(WindowEvent e) {
		   owner.killPressed();
	}
}

class WeatherAgentGUI2_this_windowAdapter extends java.awt.event.WindowAdapter {
	  WeatherAgentGUI adaptee;

	  WeatherAgentGUI2_this_windowAdapter(WeatherAgentGUI adaptee) {
	    this.adaptee = adaptee;
	  }
	  public void windowClosing(WindowEvent e) {
	    adaptee.this_windowClosing(e);
	  }
	}

class WeatherAgentGUI2_jButton1_actionAdapter implements java.awt.event.ActionListener {
	WeatherAgentGUI adaptee;

	WeatherAgentGUI2_jButton1_actionAdapter(WeatherAgentGUI adaptee) {
	    this.adaptee = adaptee;
	  }
	  public void actionPerformed(ActionEvent e) {
	    adaptee.jButton1_actionPerformed(e);
	  }


	}
