package across.simulation.constants;

public interface AcrossMessageConstants {

	/** Content for subscribing somebody's public info (Page) */
	public static final String PUBLIC_INFO_REQUEST = "PUBLIC_INFO_REQUEST";
	
	/** 
	 * Reason for CNP sent by emergency centre to the driver when it wants the driver
	 * to be scheduled for later plan execution. 
	 */
	public static final String SCHEDULE_EMERGENCY_DRIVER = "SCHEDULE_EMERGENCY_DRIVER";
	
	/** Content for REQUEST - the emergency centre cancels the driver from the schedule */ 
	public static final String CANCEL_DRIVER_SCHEDULE = "CANCEL_DRIVER_SCHEDULE";
	
	/** 
	 * Reason for CNP sent by emergency centre to a location when it wants the location
	 * to provide a certain material.  The content of the CNP is a RequestList.
	 */
	public static final String SCHEDULE_EMERGENCY_MATERIAL = "SCHEDULE_EMERGENCY_MATERIAL";

	/** Content for REQUEST - the emergency centre cancels the material from the schedule */ 
	public static final String CANCEL_MATERIAL_SCHEDULE = "CANCEL_MATERIAL_SCHEDULE";
	
	/** This is the protocol for resloving who will handle the accident. */
	public static final String ACCIDENT_HANDLING_RESOLUTION_PROTOCOL = "ACCIDENT_HANDLING_RESOLUTION_PROTOCOL";
	
}
