package across.simulation.constants;

/**
 * Constants through which the data in configurations are addressed.
 * @author Eduard Semsch
 *
 */
public interface AcrossDataConstants {
	
	/* ------------ GLOBAL DATA --------------*/
	/** Nodes of the map. across.data.AcrossMapNodes */
	public static final String MAP_NODES = "MAP_NODES";
	
	/** Arcs of the map. across.data.AcrossMapArcs */
	public static final String MAP_ARCS = "MAP_ARCS";
	
	/** Array with distances between nodes in the map, indexed like in Map_Nodes across.data.AcrossMapDistances*/
	public static final String MAP_DISTANCES = "MAP_DISTANCES";
	
	/** Planbase - across.data.TransportPlanBase */
	public static final String PLANBASE = "PLANBASE";
	
	/** Identifies an object of class SimulationObjectsConfiguration with configuration of simulation objects. */
	public static final String SIMULATION_OBJECTS_CONFIGURATION = "SIMULATION_OBJECTS_CONFIGURATION";

	/** Regions of different types of disasters. across.data.DisasterAreaConfig*/
	public static final String DISASTER_AREA = "DISASTER_AREA";
	
	/** Configuration of disasters across.data.DisasterConfig */
	public static final String DISASTER_CONFIG = "DISASTER_CONFIG";
	
	/* -------------- ALL ENTITIES --------------*/
	/**  Starting node of the driver. String */
	public static final String ENTITY_START_NODE = "ENTITY_START_NODE";
	
	/* ------------- DRIVER -----------*/
	/** Range of a sensor of a driver agent. SensorDescription */
	public static final String DRIVER_SENSOR_RANGE = "DRIVER_SENSOR_RANGE";
	
	/* ------------- LOCATION ------------ */
	/** Minimum size of the lot to acquire. Integer */
	public static final String LOCATION_MIN_LOT_SIZE = "LOCATION_MIN_LOT_SIZE";
	
	/** Seconds per one day in simulation - the day is when the locations consume the goods. Integer */
	public static final String LOCATION_SECONDS_PER_DAY = "SECONDS_PER_DAY";
	
	/** How far the location sees */
	public static final String LOCATION_SENSOR_RANGE = "LOCATION_SENSOR_RANGE";
	
	/** A circle defining the actual land of the location */
	public static final String LOCATION_VICINITY_RANGE ="LOCATION_VICINITY_RANGE"; 
	
	/* -------------- TRANSPORTER -------------*/
	/** Private prameters of the transporter - an object of class PrivateParams */
	public static final String TRANSPORTER_PRIVATE_PARAMS = "TRANSPORTER_PRIVATE_PARAMS";
	
	/** Public prameters of the transporter - an object of class PublicParams */
	public static final String TRANSPORTER_PUBLIC_PARAMS = "TRANSPORTER_PUBLIC_PARAMS";
	
	/** Parameter specifying whether the transporter can subcontract other transporters */
	public static final String TRANSPORTER_SUBCONTRACT_ALLOWED = "TRANSPORTER_SUBCONTRACT_ALLOWED";
	
	/** Parameter in Transporter's public knowledge specifying the Alliance name */
	public static final String TRANSPORTER_PARAM_ALLIANCE_NAME = "TRANSPORTER_PARAM_ALLIANCE_NAME"; 
	
	/* ------------- VEHICLE --------------*/
	/** Velocity of a vehicle. int */
	public static final String VEHICLE_VELOCITY = "VEHICLE_VELOCITY";
	
	/** Consumption of a vehicle. double */
	public static final String VEHICLE_CONSUMPTION = "VEHICLE_CONSUMPTION";
	
	/** Capacity of a vehicle. double */
	public static final String VEHICLE_CAPACITY = "VEHICLE_CAPACITY";
	
	/** Effect on simulation object. EffectOnSimulationObject*/
	public static final String VEHICLE_EFFECT = "VEHICLE_EFFECT";
	
	/** Speed of the effect on the simulation object. Integer */
	public static final String VEHICLE_EFFECT_SPEED = "VEHICLE_EFFECT_SPEED";
	
	/* ------------ EMERGENCY CENTRE ---------------- */
	/** Name of the planner agent for the emergency centre.  The name should be used as filter in dir service. */
	public static final String EMERGENCY_CENTRE_PLANNER_NAME = "EMERGENCY_CENTRE_PLANNER_NAME"; 
	
	/* =============== SIMULATION OBJECTS ============== */
	
	/** Description of an obstacle of type SimulationObjectDescription */
	public static final String SIMULATION_OBJECT_DESCRIPTION = "SIMULATION_OBJECT_DESCRIPTION";
	
}

