package across.simulation.constants;

/**
 * Constants for control communication with the EntityBehaviour.  All the constants
 * have to be used as REASON!
 * @author Eduard Semsch
 *
 */
public interface AcrossControlConstants {
	
	/**
	 * This is the reason for the topic TOPIC_ENTITY_CONTROL saying that the entit should
	 * move to Node specified by the content. This topic has 
	 * content of type String saying where the entity should move next. Client->Server
	 */
	public static final String MOVE_TO = "CONTROL_MOVE_TO";

	/**
	 * This is the reason for the topic TOPIC_ENTITY_CONTROL saying that the entity
	 * should stop. Client->Server
	 */
	public static final String STOP = "CONTROL_STOP";
	
	/** 
	 * This says that the entity cannot move to the node specified. Reason for topic TOPIC_ENTITY_CONTROL
	 * Server->Client.
	 */
	public static final String RESPONSE_BAD_NODE = "CONTROL_RESPONSE_BAD_NODE";
	
	/**
	 * Says that the entity stopped moving.  The content is String - name of the node where
	 * the entity stopped.  Reason for topic TOPIC_ENTITY_CONTROL Server->Client
	 */
	public static final String RESPONSE_STOPPED = "CONTROL_RESPONSE_STOPPED";
	
	/** This is a general error in controlling the entity behaviour. Server->Client*/
	public static final String RESPONSE_FAILURE = "CONTROL_RESPONSE_FAILURE";
	
	/** 
	 * Reason for topic TOPIC_SIMULATION_OBJECT - Server->Client
	 * Performes changes on a simulation object - content is EffectOnSimulationObject
	 */
	public static final String CHANGE_SIMULATION_OBJECT = "CONTROL_CHANGE_SIMULATION_OBJECT";
	
	/**
	 * Reason for topic TOPIC_SIMULATION_OBJECT Command for creating a simulation object.
	 * Client->Server, Server->Server, content is SimulationObject
	 */
	public static final String CREATE_SIMULATION_OBJECT = "CONTROL_CREATE_SIMULATION_OBJECT";
	
	/** 
	 * This is a reason for TOPIC_AGENT.  The content is the EntityRecord. The EntityRecord has to
	 * have these fields filled - the parameters in EntityDescriptor, the type in EntityTypeDescriptor.
	 * Other fields (including name) will be filled by the ScenarioPlayer.
	 */
	public static final String CREATE_AGENT = "CREATE_AGENT";
	
	/**
	 * This is a reason for TOPIC_AGENT. The content is a String - the container name.
	 */
	public static final String REMOVE_AGENT = "REMOVE_AGENT";
}
