package across.simulation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

import across.data.simulation.SimulationObject;
import across.data.simulation.SimulationObjectDescription;
import across.data.simulation.SimulationObjectsConfiguration;
import across.simulation.constants.AcrossControlConstants;
import across.simulation.constants.AcrossDataConstants;
import across.simulation.constants.AcrossEntityConstants;
import across.simulation.constants.AcrossTopicConstants;
import across.simulation.constants.AcrossVisioConstants;
import aglobe.container.transport.Address;
import aglobe.ontology.ContainerStartup;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobex.simulation.entitymanager.ScenarioControl;
import aglobex.simulation.entitymanager.ScenarioPlayer;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;

/**
 * This is ACROSS specific scenario player - it is used for spawning special entities in the
 * simulation e.g. the road obstacles.
 * @author Eduard Semsch
 *
 */
public class AcrossScenarioPlayer implements ScenarioPlayer {

	private ScenarioControl scenarioControl;
	
	private SimulationObjectsConfiguration objConf; 
	
	private int indexToSlotArray = 0;
	
	private List<EntityRecord> obstacleList = new ArrayList<EntityRecord>();
	
	private Configuration configuration;
	
	private List<String> removedEntities = new LinkedList<String>();
	
	public void configurationUpdated(Configuration newConfiguration, HashMap<String, String> paramsString, HashMap<String, Double> paramsDouble, HashMap<String, Integer> paramsInteger, HashMap<String, Boolean> paramsBoolean, HashMap<String, Long> paramsLong, HashMap<String, InputStream> files, HashMap<String, Object> objects) {
		objConf = (SimulationObjectsConfiguration) objects.get(AcrossDataConstants.SIMULATION_OBJECTS_CONFIGURATION);
		configuration = newConfiguration;
	}

	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	public void endOfScenario(long endTime) {
		// TODO Auto-generated method stub
		
	}

	public void setScenarioControl(final ScenarioControl scenarioControl) {
		this.scenarioControl = scenarioControl;
		scenarioControl.getGISShell().subscribeTopic(AcrossTopicConstants.TOPIC_SIMULATION_OBJECT, new GISTopicServerListenerWithoutLogin() {

			public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
				if(reason.equalsIgnoreCase(AcrossControlConstants.CREATE_SIMULATION_OBJECT)) {
					SimulationObject sobj = (SimulationObject) content;
					spawnSimulationObject(sobj);
				}
			}

			public void addEvent(Runnable e) {
				AcrossScenarioPlayer.this.scenarioControl.getOwnerAgent().addEvent(e);
			}
			
		});

		scenarioControl.getGISShell().subscribeTopic(AcrossTopicConstants.TOPIC_AGENT, new GISTopicServerListenerWithoutLogin() {

			public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
				if(reason.equalsIgnoreCase(AcrossControlConstants.CREATE_AGENT)) {
					EntityRecord er = (EntityRecord) content;
					spawnSimulationAgent(er);
				} else if (reason.equalsIgnoreCase(AcrossControlConstants.REMOVE_AGENT)) {
					removeEntity((String) content);
				}
			}

			public void addEvent(Runnable e) {
				AcrossScenarioPlayer.this.scenarioControl.getOwnerAgent().addEvent(e);
			}
			
		});
	}

	public void simulationTimestampUpdated(long time) {
		
	}

	public void startReplay(long startTime) {
		// TODO Auto-generated method stub
		
	}

	/**
	 * Starts the scenario - spawns simulation objects.
	 */
	public void startScenario(long startTime, boolean fastSimulation) {
		if(objConf!=null) {
			if(objConf.getSimulationObjects()==null) {
				return;
			}
			for (SimulationObject sobj : objConf.getSimulationObjects()) {
				spawnSimulationObject(sobj);
			}
		}
	}

	/** Removes an entity from simulation. */
	protected void removeEntity(String containerName) {
		synchronized(removedEntities) {
			if(!removedEntities.contains(containerName)) {
				removedEntities.add(containerName);
				scenarioControl.removeEntity(containerName);
			}
		}
	}
	
	/** Creates a new simulation agent. Can only create a terrorist */
	protected void spawnSimulationAgent(EntityRecord er) {
		// find type descriptor for entity
		if(er.entityDescriptor.typeDescriptor.typeName.equals("TERRORIST_DRIVER_ENTITY_TYPE")) {
			// FIXME - do this better
			EntityRecord terer = scenarioControl.getRunningEntityRecord("Terrorist");
			String name = "Terrorist"+indexToSlotArray;
			Address a = Address.getAgentAddress(scenarioControl.getOwnerAgent().getAddress().getHost(), scenarioControl.getOwnerAgent().getAddress().getPort(), name, name);
			er.address = a;
			er.containerName = name;
			er.indexToSlotArray = indexToSlotArray;
			indexToSlotArray++;
			er.platform = terer.platform;
			er.entityDescriptor.typeDescriptor = terer.entityDescriptor.typeDescriptor;
		}
		String agentMain = null;
		if(er.entityDescriptor.typeDescriptor.typeName.equals("TERRORIST_DRIVER_ENTITY_TYPE")) {
			agentMain = "across.agents.terrorists.driver.TerroristDriverAgent";
		}
		ContainerStartup cs = new ContainerStartup();
		cs.addAgent(er.containerName, agentMain, new ArrayList<String>(), new LinkedHashMap<String, String>());
		try {
			scenarioControl.crateNewEntity(er, cs);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Creates the obstacle entity in the simulation.
	 * @param obstacle
	 */
	protected void spawnSimulationObject(SimulationObject so) {
		try {
			EntityRecord er = simObjectER(so);
			scenarioControl.crateNewEntity(er, null);
			obstacleList.add(er);
		} catch (Exception e) {
			scenarioControl.logSevere("Unable to start object: "+so.getSimulationObjectDescription().getName());
			e.printStackTrace();
		}
	}
	
	/**
	 * Creates the entity record for a simulation object
	 * @param so
	 * @return
	 */
	private EntityRecord simObjectER(SimulationObject so) {
		EntityDescriptor ed = new EntityDescriptor();
		ed.typeDescriptor = new EntityTypeDescriptor();
		ed.typeDescriptor.simulationClass = so.getSimulationClass();
		ed.typeDescriptor.typeName = AcrossEntityConstants.SIMULATION_OBJECT_TYPE;
		ed.typeDescriptor.crashRange = 0;

		SimulationObjectDescription sod = so.getSimulationObjectDescription();
		String objName = sod.getName();
		
		ed.confParamsString = new LinkedHashMap<String,String>();
		ed.confParamsString.put(AcrossVisioConstants.ENTITY_VISIO_NAME, objName);
		ed.confParamsString.put(AcrossVisioConstants.ENTITY_VISIO_OBJECT, "CAR");
		ed.confParamsString.put(AcrossVisioConstants.ENTITY_VISIO_TEXTURE, "TEXTURE_CAR_KABINA_TEXTURE05");
		
		ed.confObjects = new LinkedHashMap<String,Object>();
		ed.confObjects.put(AcrossDataConstants.SIMULATION_OBJECT_DESCRIPTION, sod);
		
		EntityRecord er = new EntityRecord();
		er.entityDescriptor = ed;
		er.containerName = objName;
		er.indexToSlotArray = indexToSlotArray;
		indexToSlotArray++;
		return er;
	}
}