package across.data.simulation;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Provides the description of a simulation object - its identifiaction,
 * location and parameters.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="SimulationObjectDescription",propOrder={})
public class SimulationObjectDescription implements Serializable {

	/** Name of the object container in the simulation - should be unique! */
	@XmlAttribute(name="Name")
	private String Name;
	
	/** X coordinate */
	@XmlAttribute(name="X")
	private Double X;
	
	/** Y coordinate */
	@XmlAttribute(name="Y")
	private Double Y;
	
	/** Z coordinate */
	@XmlAttribute(name="Z")
	private Double Z;
	
	/** Type of the simulation object - for visulalization */
	@XmlAttribute(name="ObjectType")
	private String ObjectType;
	
	/** Extent of construction damage - 0 - 100 */
	@XmlAttribute(name="ConstructionDamage")
	private int ConstructionDamage;
	
	/** Extent of fire at the site of accident - 0 - 100 */
	@XmlAttribute(name="ExtentOfFire")
	private int ExtentOfFire;
	
	/** Level of insurgency at the place - 0 - 100*/
	@XmlAttribute(name="InsurgencyLevel")
	private int InsurgencyLevel;
	
	/** Number of wounded people */
	@XmlAttribute(name="NumberOfWounded")
	private int NumberOfWounded;
	
	@XmlElement(name="Location")
	private SimulationObjectLocation Location;
	
	public int getExtentOfFire() {
		return ExtentOfFire;
	}

	public void setExtentOfFire(int extentOfFire) {
		ExtentOfFire = extentOfFire;
	}

	public int getInsurgencyLevel() {
		return InsurgencyLevel;
	}

	public void setInsurgencyLevel(int insurgencyLevel) {
		InsurgencyLevel = insurgencyLevel;
	}

	public String getObjectType() {
		return ObjectType;
	}

	public void setObjectType(String objectType) {
		ObjectType = objectType;
	}

	public int getConstructionDamage() {
		return ConstructionDamage;
	}

	public void setConstructionDamage(int constructionDamage) {
		ConstructionDamage = constructionDamage;
	}

	public int getNumberOfWounded() {
		return NumberOfWounded;
	}

	public void setNumberOfWounded(int numberOfWounded) {
		NumberOfWounded = numberOfWounded;
	}

	public String getName() {
		return Name;
	}

	public void setName(String name) {
		Name = name;
	}

	public Double getX() {
		return X;
	}

	public void setX(Double x) {
		X = x;
	}

	public Double getY() {
		return Y;
	}

	public void setY(Double y) {
		Y = y;
	}

	public Double getZ() {
		return Z;
	}

	public void setZ(Double z) {
		Z = z;
	}
	
	/**
	 * Applies a diff to the construction damage.
	 * @param diff
	 * @return true if the value is zero
	 */
	public boolean adjustConstructionDamage(int diff) {
		ConstructionDamage += diff;
		if(ConstructionDamage<=0) {
			ConstructionDamage = 0;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Applies a diff to the extent of fire.
	 * @param diff
	 * @return true if the value is zero
	 */
	public boolean adjustFireExtent(int diff) {
		ExtentOfFire += diff;
		if(ExtentOfFire<=0) {
			ExtentOfFire = 0;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Applies a diff to the construction damage.
	 * @param diff
	 * @return true if the value is zero
	 */
	public boolean adjustInsurgencyLevel(int diff) {
		InsurgencyLevel += diff;
		if(InsurgencyLevel<=0) {
			InsurgencyLevel = 0;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Applies a diff to the number of wounded.
	 * @param diff
	 * @return true if the value is zero
	 */
	public boolean adjustNumberOfWounded(int diff) {
		NumberOfWounded += diff;
		if(NumberOfWounded<=0) {
			NumberOfWounded = 0;
			return true;
		} else {
			return false;
		}
	}

	public SimulationObjectLocation getLocation() {
		return Location;
	}

	public void setLocation(SimulationObjectLocation location) {
		Location = location;
	}
	
}
