package across.data.simulation;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Specifies an effect on a simulation object.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="EffectOnSimulationObject",propOrder={})
@XmlRootElement(name="EffectOnSimulationObject")
public class EffectOnSimulationObject implements Serializable {
	
	/** Name of the object to change */
	@XmlAttribute(name="objectName")
	public String objectName;
	
	/** Change in insurgency level */
	@XmlAttribute(name="insurgencyDiff")	
	public int insurgencyDiff = 0;
	
	/** Change in fire extent level */
	@XmlAttribute(name="fireDiff")	
	public int fireDiff = 0;
	
	/** Change in construction damage level */
	@XmlAttribute(name="constructionDamageDiff")	
	public int constructionDamageDiff = 0;
	
	/** Change in number of wounded */
	@XmlAttribute(name="woundedDiff")	
	public int woundedDiff = 0;
	
	public EffectOnSimulationObject() {
		
	}

	public EffectOnSimulationObject(String objectName) {
		this.objectName = objectName;
	}
	
	/**
	 * Returns a new instance of EffectOnSimulationObject with a new object ID and values
	 * from the default effect specified.
	 * @param objId
	 * @param defaultEffect
	 * @return
	 */
	public static EffectOnSimulationObject getEffectForObjectAndDefaultEffect(String objId, EffectOnSimulationObject defaultEffect) {
		EffectOnSimulationObject newEff = new EffectOnSimulationObject(objId);
		newEff.constructionDamageDiff = defaultEffect.constructionDamageDiff;
		newEff.fireDiff = defaultEffect.fireDiff;
		newEff.insurgencyDiff = defaultEffect.insurgencyDiff;
		newEff.woundedDiff = defaultEffect.woundedDiff;
		return newEff;
	}
}
