package across.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import aglobe.container.transport.Address;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="TeamProposal",propOrder={"TransportCfp","TeamLeader","TeamMember","RequestedServices","StartNodeTeamMember","TargetNodeTeamMember"})
public class TeamProposal implements Serializable {

	@XmlElement(name="TransportCfp")
    private TransportCfp TransportCfp;
	@XmlElement(name="TeamLeader")
    private Address TeamLeader;
	@XmlElement(name="TeamMember")
    private List<Address> TeamMember;
	@XmlElement(name="RequestedServices")
    private TransportCfp RequestedServices;
	@XmlElement(name="StartNodeTeamMember")
    private List<Address> StartNodeTeamMember;
	@XmlElement(name="TargetNodeTeamMember")
    private List<Address> TargetNodeTeamMember;
	public TransportCfp getRequestedServices() {
		return RequestedServices;
	}
	public void setRequestedServices(TransportCfp requestedServices) {
		RequestedServices = requestedServices;
	}
	public List<Address> getStartNodeTeamMember() {
		if(StartNodeTeamMember == null) {
			StartNodeTeamMember = new ArrayList<Address>();
		}
		return StartNodeTeamMember;
	}
	public void setStartNodeTeamMember(List<Address> startNodeTeamMember) {
		StartNodeTeamMember = startNodeTeamMember;
	}
	public List<Address> getTargetNodeTeamMember() {
		if(TargetNodeTeamMember == null) {
			TargetNodeTeamMember = new ArrayList<Address>();
		}
		return TargetNodeTeamMember;
	}
	public void setTargetNodeTeamMember(List<Address> targetNodeTeamMember) {
		TargetNodeTeamMember = targetNodeTeamMember;
	}
	public Address getTeamLeader() {
		return TeamLeader;
	}
	public void setTeamLeader(Address teamLeader) {
		TeamLeader = teamLeader;
	}
	public List<Address> getTeamMember() {
		if(TeamMember == null) {
			TeamMember = new ArrayList<Address>();
		}
		return TeamMember;
	}
	public void setTeamMember(List<Address> teamMember) {
		TeamMember = teamMember;
	}
	public TransportCfp getTransportCfp() {
		return TransportCfp;
	}
	public void setTransportCfp(TransportCfp transportCfp) {
		TransportCfp = transportCfp;
	}
}
