
package across.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import aglobe.container.transport.Address;

/*
  long
  Address
  String
  String
  List<Batch>
*/

/**
 * A list of batches with specified delivery address and location.  The request list is
 * identified by a unique id.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="RequestList",propOrder={"Batch"})
public class RequestList implements Serializable {

	@XmlAttribute(name="RequestTime")
    private long RequestTime;
	@XmlAttribute(name="DeliveryAddress")
    private Address DeliveryAddress;
	@XmlAttribute(name="Requestid")
    private String Requestid;
	@XmlAttribute(name="DeliveryLocation")
    private String DeliveryLocation;
	@XmlElement(name="Batch")
    private List<Batch> Batch;
	public List<Batch> getBatch() {
		if(Batch==null) {
			Batch = new ArrayList<Batch>();
		}
		return Batch;
	}
	public void setBatch(List<Batch> batch) {
		Batch = batch;
	}
	public Address getDeliveryAddress() {
		return DeliveryAddress;
	}
	public void setDeliveryAddress(Address deliveryAddress) {
		DeliveryAddress = deliveryAddress;
	}
	public String getDeliveryLocation() {
		return DeliveryLocation;
	}
	public void setDeliveryLocation(String deliveryLocation) {
		DeliveryLocation = deliveryLocation;
	}
	public String getRequestid() {
		return Requestid;
	}
	public void setRequestid(String requestid) {
		Requestid = requestid;
	}
	public long getRequestTime() {
		return RequestTime;
	}
	public void setRequestTime(long requestTime) {
		RequestTime = requestTime;
	}
	public String toString() {
        StringBuffer sb = new StringBuffer("<<RequestList");
        sb.append(" requestTime=");
        sb.append(Long.toString(RequestTime));
        sb.append(" deliveryAddress=");
        sb.append(DeliveryAddress.toString());
        sb.append(" requestid=");
        sb.append(Requestid.toString());
        sb.append(" deliveryLocation=");
        sb.append(DeliveryLocation.toString());
        sb.append(" Batch=");
        sb.append(Batch.toString());
        sb.append(">>");
        return sb.toString();
    }
}