
package across.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/*
  long
  long
  String
  List<ItemCoverage>
*/
/**
 * Class specifing that some things are going to be done (there is coverage of an item specified that
 * specifies how much it is going to be done) and the total price of the things.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="Proposal",propOrder={"ItemCoverage"})
public class Proposal implements Serializable {

	@XmlAttribute(name="ProposalTime")
    private long ProposalTime;
	@XmlAttribute(name="TotalPrice")
    private long TotalPrice;
	@XmlAttribute(name="Requestid")
    private String Requestid;
    @XmlElement(name="ItemCoverage")
    private List<ItemCoverage> ItemCoverage;
	public List<ItemCoverage> getItemCoverage() {
		if(ItemCoverage==null) {
			ItemCoverage = new ArrayList<ItemCoverage>();
		}
		return ItemCoverage;
	}
	public void setItemCoverage(List<ItemCoverage> itemCoverage) {
		ItemCoverage = itemCoverage;
	}
	public long getProposalTime() {
		return ProposalTime;
	}
	public void setProposalTime(long proposalTime) {
		ProposalTime = proposalTime;
	}
	public String getRequestid() {
		return Requestid;
	}
	public void setRequestid(String requestid) {
		Requestid = requestid;
	}
	public long getTotalPrice() {
		return TotalPrice;
	}
	public void setTotalPrice(long totalPrice) {
		TotalPrice = totalPrice;
	}
	
	public String toString() {
        StringBuffer sb = new StringBuffer("<<Proposal");
        sb.append(" proposalTime=");
        sb.append(Long.toString(ProposalTime));
        sb.append(" totalPrice=");
        sb.append(Long.toString(TotalPrice));
        sb.append(" requestid=");
        sb.append(Requestid.toString());
        sb.append(" ItemCoverage=");
        if(ItemCoverage!=null && ItemCoverage.size()>0) {
        	sb.append(ItemCoverage.toString());
        }
        sb.append(">>");
        return sb.toString();
    }
}