package across.data;

import java.io.Serializable;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import aglobe.container.transport.Address;

/*
  long
  double
  String
  Address
  List<Address>
*/
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="CooperationResult",propOrder={"TeamLeader","TeamMember"})
public class CooperationResult implements Serializable {
	
	@XmlAttribute(name="Payement")
    private long Payement;

    @XmlAttribute(name="GlobalTrust")
    private double GlobalTrust;
    
    @XmlAttribute(name="Requestid")
    private String Requestid;
    
    @XmlElement(name="TeamLeader")
    private Address TeamLeader;
    
    @XmlElement(name="TeamMember")
    private List<Address> TeamMember;

	public double getGlobalTrust() {
		return GlobalTrust;
	}

	public void setGlobalTrust(double globalTrust) {
		GlobalTrust = globalTrust;
	}

	public long getPayement() {
		return Payement;
	}

	public void setPayement(long payement) {
		Payement = payement;
	}

	public String getRequestid() {
		return Requestid;
	}

	public void setRequestid(String requestid) {
		Requestid = requestid;
	}

	public Address getTeamLeader() {
		return TeamLeader;
	}

	public void setTeamLeader(Address teamLeader) {
		TeamLeader = teamLeader;
	}

	public List<Address> getTeamMember() {
		return TeamMember;
	}

	public void setTeamMember(List<Address> teamMember) {
		TeamMember = teamMember;
	}

}