package across.data;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/*
  long
  long
  long
  String
*/

/**
 * A batch of commodity.  It is used whenever the commodity is being traded or moved between location.  It
 * specifies the exact commodity with its amount, delivery time.  It also has a unique ID that identifies the
 * batch in the system.
 * <p>
 * A batch is basically a portion of commodity (commodity name and amount) identified by a unique ID.
 * @author Eduard Semsch
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name="Batch",propOrder={})
public class Batch implements Serializable {

	@XmlAttribute(name="Batchid")
    private long Batchid;
    @XmlAttribute(name="Count")
    private long Count;
    @XmlAttribute(name="DeliveryTime")
    private long DeliveryTime;
    @XmlAttribute(name="ComodityName")
    private String ComodityName;
	public long getBatchid() {
		return Batchid;
	}
	public void setBatchid(long batchid) {
		Batchid = batchid;
	}
	public String getComodityName() {
		return ComodityName;
	}
	public void setComodityName(String comodityName) {
		ComodityName = comodityName;
	}
	public long getCount() {
		return Count;
	}
	public void setCount(long count) {
		Count = count;
	}
	public long getDeliveryTime() {
		return DeliveryTime;
	}
	public void setDeliveryTime(long deliveryTime) {
		DeliveryTime = deliveryTime;
	}

	 public String toString() {
        StringBuffer sb = new StringBuffer("<<Batch");
        sb.append(" batchid=");
        sb.append(Long.toString(Batchid));
        sb.append(" count=");
        sb.append(Long.toString(Count));
        sb.append(" deliveryTime=");
        sb.append(Long.toString(DeliveryTime));
        sb.append(" comodityName=");
        sb.append(ComodityName.toString());
        sb.append(">>");
        return sb.toString();
    }
	
}