package across.agents.transporter.util.checker;

import java.util.Collection;

import across.data.Page;
import across.data.Resource;
import across.data.TransportCfp;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;

public interface RestrictionsChecker {

  public void loadRestrictions(String path, AgentInfo agentInfo);
  public void agentPageUpdated(Page page);

  public boolean acceptAllianceMember(AgentKnowledge member);
  public boolean acceptTeamMember(Address member);
  public boolean acceptTeamLeader(Address teamLeader);
  public boolean acceptRequestedServices(TransportCfp requestedServices);
  /** Returns available actions for the Resource passed in as a param */
  public Collection<String> getAvailableActions(Resource res);
}
