package across.agents.transporter.util.checker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;

import across.agents.transporter.TransporterAgent;
import across.data.Page;
import across.data.Resource;
import across.data.TransportCfp;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2004</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class JavaRestrictionsChecker implements RestrictionsChecker{

  TransporterAgent owner;

  RestrictionsChecker compiledRestrictionsChecker = null;

  public JavaRestrictionsChecker(TransporterAgent owner) {
    this.owner = owner;
  }

  public void loadRestrictions(String filePath, AgentInfo agentInfo) {
      String rulesFile = "test/privateJava.txt";
      String importFile = "test/privateJavaImports.txt";
//    String privateFile = filePath + "/privateJava.txt";
      String className =  owner.getName() + "Restrictions";
      String javaFilePath = "cache/across/transporter/";
      new File(javaFilePath).mkdirs();
      String javaFile = javaFilePath +  className + ".java";

      try {
          createJavaFile(importFile, rulesFile, javaFile, className);
          compile(javaFile);
          compiledRestrictionsChecker = loadClass(className);
      }
      catch (Exception ex) {
          owner.getLogger().severe("Cannot initialize JavaRestrictionsChecker: " + ex);
      }

      compiledRestrictionsChecker.loadRestrictions(filePath, agentInfo);
  }

    /**
     * loadClass
     *
     * @param className String
     * @param javaFilePath String
     * @return RestrictionsChecker
     */
    private RestrictionsChecker loadClass(String className) {
        ClassLoader classLoader = new ClassLoader() {
            private byte[] getBytes(String filename) throws IOException {
                File file = new File(filename);
                long len = file.length();
                byte raw[] = new byte[ (int) len];
                FileInputStream fin = new FileInputStream(file);
                int r = fin.read(raw);
                if (r != len)
                    throw new IOException("Can't read all, " + r + " != " + len);
                fin.close();
                return raw;

            }

            public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class clas = null;
                clas = findLoadedClass(name);
                String fileStub = name.replace('.', '/');
                String classFilename = "cache/" + fileStub + ".class";
                File classFile = new File(classFilename);
                try {
                    byte raw[] = getBytes(classFilename);
                    clas = defineClass(name, raw, 0, raw.length);
                }
                catch (IOException ie) {
                }
                if (clas == null) {
                    clas = findSystemClass(name);
                }
                if (resolve && clas != null)
                    resolveClass(clas);
                if (clas == null)
                    throw new ClassNotFoundException(name);
                return clas;
            }

        };
        Class clas = null;
        RestrictionsChecker rc = null;
        try {
            clas = classLoader.loadClass("across.transporter."+className);
            rc = (RestrictionsChecker) clas.getConstructor(new Class[] {TransporterAgent.class}).newInstance(new Object[] {owner});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }

        return rc;
    }

    void createJavaFile(String imports,String rules, String java, String className) throws IOException {
      InputStream rulesStream = new FileInputStream(rules);
      InputStream importsStream = new FileInputStream(imports);
      OutputStream out = new FileOutputStream(java);

      out.write("package across.transporter;\n \n".getBytes());
      out.write("import across.skn.AgentKnowledge;\n".getBytes());
      out.write("import aglobe.container.transport.Address;\n".getBytes());
      out.write("import across.data.Page;\n".getBytes());
      out.write("import across.data.TransportCfp;\n \n".getBytes());

      byte[] buf = new byte[1024];
      int len;

      while ( (len = importsStream.read(buf)) > 0) {
          out.write(buf, 0, len);
      }

      out.write(("\n public class "+className+" implements RestrictionsChecker{\n").getBytes());

      out.write("    TransporterAgent owner;\n".getBytes());

      out.write("\n".getBytes());
      out.write(("    public "+className+"(TransporterAgent owner) {\n").getBytes());
      out.write("        this.owner = owner;\n".getBytes());
      out.write("    }\n".getBytes());
      out.write("\n".getBytes());

      while ( (len = rulesStream.read(buf)) > 0) {
          out.write(buf, 0, len);
      }

      rulesStream.close();
      importsStream.close();
      out.write("\n} \n".getBytes());
      out.close();
  }

  private void compile(String javaFile) throws IOException,
        InterruptedException {
        String command = "javac -classpath ./classes;./lib/JTP/lib/antlr.jar;./lib/JTP/lib/icu4j.jar;./lib/JTP/lib/jakarta-oro-2.0.5.jar;./lib/JTP/lib/jdom.jar;./lib/JTP/lib/jena.jar;./lib/JTP/lib/jtp.jar;./lib/JTP/lib/log4j.jar;./lib/JTP/lib/xercesImpl.jar;./lib/JTP/lib/xmlParserAPIs.jar;./lib/JPL/jpl.jar;./lib/JUnit/junit.jar;./lib/JBCL/jbcl.jar;../aglobe/classes;../aglobe/libs/FileInputTextField.jar;../ontology/libs/jaxb-rt-1.0-ea.jar;../ontology/classes " + javaFile;
        System.out.println("compiling : " + command);
      Process p = Runtime.getRuntime().exec(command);
      p.waitFor();
  }

  /**
   * acceptAllianceMember
   *
   * @param member AgentKnowledge
   * @return boolean
   * @todo Implement this across.transporter.RestrictionsChecker method
   */
  public boolean acceptAllianceMember(AgentKnowledge member) {
    if (compiledRestrictionsChecker == null) {
      throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
    }
    return compiledRestrictionsChecker.acceptAllianceMember(member);
  }

  /**
   *
   * @param teamProposal TeamProposal
   * @return boolean
   * @todo Implement this across.transporter.RestrictionsChecker method
   */
  public boolean acceptRequestedServices(TransportCfp requestedServices) {
    if (compiledRestrictionsChecker == null) {
      throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
    }
    return compiledRestrictionsChecker.acceptRequestedServices(requestedServices);
  }

  /**
   * acceptTeamLeader
   *
   * @param teamLeader Address
   * @return boolean
   * @todo Implement this across.transporter.RestrictionsChecker method
   */
  public boolean acceptTeamLeader(Address teamLeader) {
    if (compiledRestrictionsChecker == null) {
      throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
    }
    return compiledRestrictionsChecker.acceptTeamLeader(teamLeader);
  }

  /**
   * acceptTeamMember
   *
   * @param member Address
   * @return boolean
   * @todo Implement this across.transporter.RestrictionsChecker method
   */
  public boolean acceptTeamMember(Address member) {
    if (compiledRestrictionsChecker == null) {
      throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
    }
    return compiledRestrictionsChecker.acceptTeamMember(member);
  }

  public void agentPageUpdated(Page page) {
  }
  
  public Collection<String> getAvailableActions(Resource res) {
		return new LinkedList<String>();
  }

}
