package across.agents.transporter.util.checker;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import across.agents.transporter.TransporterAgent;
import across.data.Page;
import across.data.Param;
import across.data.Possibility;
import across.data.PrivateParams;
import across.data.PublicParams;
import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.InterLinguaTools;
import across.util.XMLtools;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;

// REMOVE
/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2004</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class DNFRestrictionsChecker
    implements RestrictionsChecker {
  TransporterAgent owner;

  /** Agent's private parameters */
  protected PrivateParams privateParams;


  public DNFRestrictionsChecker(TransporterAgent owner) {
    this.owner = owner;
  }

  public void setTransporterPrivateParams(PrivateParams pp) {
	  this.privateParams = pp;
  }

  public void loadRestrictions(String filePath, AgentInfo agentInfo) {
      // create semiPrivateParams accessible to alliance members
      owner.setupSemiPrivateFromPrivate();

      owner.gui.setPrivate(privateParams);
  }

  /**
   * Determines if the agent wishes to be a part of coalition formed by leader.
   * @param teamLeader leader of the coalition
   * @return true if acceptts, false if refuses
   */
  public boolean acceptTeamLeader(Address teamLeader) {
      AgentKnowledge ak = owner.community.getAgent(teamLeader.getName());
      if (!teamLeader.equals(owner.getAddress())) {
          if (ak != null) {
              //checking private restrictions for teammeber
              return checkRestrictions(ak.publicParams.getParam(),  privateParams.getCoalitionLeaderRestrictions().getPossibility());
          } else {
              owner.getLogger().info("Unknown agent wants to be coalition leader: " + owner.getName() + "->" + teamLeader);
              return false;
          }
      } else {
          return true; // for myself
      }
  }

  /**
   * says whether <code>params</code> corresponds to private restrictions specified as list of Possibilities
   * Can be used for both alliance and coalition restrictions
   * @param params List of Param - information about subject
   * @param possibilities List of Possibility - restrictions on the subject
   * @return boolean
   */
  public static boolean checkRestrictions(List params, List possibilities) {
      for (Iterator iter = possibilities.iterator(); iter.hasNext(); )
      {
          Possibility possibility = (Possibility)iter.next();
          boolean posMatches = true;
          for (Iterator iterPos = possibility.getPositive().getParam().iterator(); iterPos.hasNext(); )
          {
              Param param = (Param)iterPos.next();
              String name = param.getName();
              String value = param.getValue();
              if (!value.equalsIgnoreCase(InterLinguaTools.getParamValue(params, name))) {
                  posMatches = false;
                  break;
              }
          }
          if (!posMatches) continue; // it is not necessary to test negative values
          boolean negMatches = true;
          for (Iterator iterPos = possibility.getNegative().getParam().iterator(); iterPos.hasNext(); )
          {
              Param param = (Param)iterPos.next();
              String name = param.getName();
              String value = param.getValue();
              if (value.equalsIgnoreCase(InterLinguaTools.getParamValue(params, name))) {
                  negMatches = false;
                  break;
              }
          }
          if (!negMatches) continue;
          return true;
      }
      return false;
  }


  /**
   * acceptTeamMember - determines if the agent wishes to be a part of coalition with member
   *
   * @param member - one of the member of the coalition
   * @return boolean true if accepts, false if not
   */
  public boolean acceptTeamMember(Address member)
  {
      /** @todo consider also call for proposal ? */ //todo ?
      AgentKnowledge ak = owner.community.getAgent(member.getName());
      if (!member.equals(owner.getAddress()))
      {
          if (ak != null)
          {
              //checking private restrictions for teammeber

              if (ak.publicParams == null) {
                   System.out.println("@@@ SUSPITIOUS: ak!=null, but publicParams==null -> publicParams unknown: DON'T ACCEPT AS TEAM MEMBER");
                   return false;
              }
/*        //debug
              List test1 = ak.publicParams.getParam();
              List test2 = privateParams.getCoalitionRestrictions().getPossibility();
              assert (test1 != null);
              assert (test2 != null);
  */
              return checkRestrictions(ak.publicParams.getParam(), privateParams.getCoalitionRestrictions().getPossibility());
          }
          else
          {
              owner.getLogger().info("Unknown agent wants to be coalition member: " + owner.getName() + "->" + member);
              return false;
          }
      }
      else
      {
        return true; // for myself
      }
  }



  public boolean acceptAllianceMember(AgentKnowledge member) {
      PublicParams pi = member.publicParams;
      if (null != pi)
      {
          List p = pi.getParam();
          List pos = privateParams.getAllianceRestrictions().getPossibility();
          return checkRestrictions(p, pos);
      }
      owner.getLogger().warning(owner.getName() + ": Public info not available for agent: " + member.address.getName());
      return false;
  }


  /**
   * Returns true if agent agrees with tasks specified in requestedServices structure of the teamProposal and
   * total transport cfp
   * @param teamProposal - used to obtain the info about requsted services and transportCfp
   * @return true if acceptable
   */
  public boolean acceptRequestedServices(TransportCfp requestedServices)
  {
      // pass through all the batches and check the restrictions for each one of them...
      for (Iterator rsit = requestedServices.getTransportBatch().iterator(); rsit.hasNext();)
      {
          TransportBatch tb = (TransportBatch) rsit.next();
          List servicesProps = new LinkedList();
          servicesProps.add(XMLtools.makeParam("start",tb.getStart()));
          servicesProps.add(XMLtools.makeParam("target",tb.getTarget()));
          servicesProps.add(XMLtools.makeParam("comodityName",tb.getComodityName()));
          if (! checkRestrictions(servicesProps, privateParams.getCoalitionGoalRestrictions().getPossibility()))
          {
              return false;
          }
      }
      return true;
  }

  public void agentPageUpdated(Page page) {
  }


public Collection<String> getAvailableActions(Resource res) {
	return new LinkedList<String>();
}
  
  
}
