package across.agents.transporter.task;

import java.util.Iterator;

import across.agents.transporter.TransporterAgent;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;

/**
 * This class is used by current alliance member when new agent wants to join alliance. Contacted agent asks
 * all alliance agents whether they agree with new member entry.
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: ATG, FEE CTU</p>
 * @author Jan Tozicka
 * @version 1.0
 */
public class RequstJoinAllianceParticipantTask extends aglobex.protocol.request.RequestParticipantTask {
    protected TransporterAgent myAgent;
    int votingAgents;
    int positiveVotes;
    int negativeVotes;

    public RequstJoinAllianceParticipantTask(TransporterAgent myAgent, Message msg){
      super(myAgent, msg, false);
      this.myAgent = myAgent;
      this.requestMessage = msg;
    }

    /**
     * starts QueryIf task with all alliance members (and itself) - if all agree new member is accepted
     * @param requestMessage
     */
    protected void processRequest(Message requestMessage){
      votingAgents = myAgent.getAllianceMembers().size();

      // firstly I will check whether I accept...
      if (!myAgent.acceptAllianceMember(requestMessage, myAgent.getAddress())) {
        refuse();
        cancelTask();
        return;
      } else if (votingAgents == 0) {
        informDone();
        cancelTask();
        return;
      }

      // if so I will ask other agents

      for (Iterator iter = myAgent.getAllianceMembers().iterator(); iter.hasNext(); ) {
        Address address = (Address) iter.next();
        /** @todo use different content instead of requestMessage; e.g. to send my info */
        new aglobex.protocol.queryif.QueryIfInitiatorTask(myAgent, address, requestMessage) {

          protected void informTrue() {
            positiveVotes++;
            checkAllVotes();
            cancelTask();
          }

          protected void informFalse() {
            negativeVotes++;
            checkAllVotes();
            cancelTask();
          }
        };

      }
    }

    protected void checkAllVotes() {
      if (positiveVotes + negativeVotes == votingAgents) {
        //all agents have voted - we can check result and end this task

        if (negativeVotes == 0) {
          informDone();
        } else {
          assert negativeVotes > 0 : negativeVotes;
          refuse();
        }

        cancelTask();
      }
    }
}

