/*
 * CNPTransportWithSubcontractTask.java
 *
 * Created on 2. listopad 2004, 10:08
 */

package across.agents.transporter.task;

/**
 *
 * @author  biba
 */

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

import across.agents.transporter.TransporterAgent;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.visio.VisualAgent;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobex.simulation.protocol.cnp.CNPInitiatorTask;

/**
 * task initiating CNP to subcontract cooperators from other alliances
 */

public class CNPTransportSubcontractTask extends CNPInitiatorTask {

    TransporterAgent owner;

    /** reference to the task handling the primary contract to be possible send the merged proposal to location */
    CNPTransportBidAnswer primaryContractTask;

    /** stores the subcontract cfp content */
    TransportCfp subcontractCfp;

    /** stores the origina cfp from location */
    TransportCfp fromLocationCfp;

    /** proposal of the primary contract to be merged with the best proposal from other aliances and send to location via CNPTransportBidAnswer method */
    Proposal primaryContractProposal;
//    /** transport batch containing covered items */
//    TransportBatch transportBatch;

    /** the best offer transporter - if location accepts the primary contract, proposalAccepted is sent to the best offer transporter */
    Map<Address,Object> acceptedParticipants;

    /** best proposal from other alliances */
    Proposal bestProposal = null;

    protected GISClientService.Shell gisShell;

    TeamProposal primaryTeamProposal;
    Proposal myProposal;

    /** list of ratios to multiply particular subcontract coverages in order to relate them to primary contract coverages */
    //double subcontractCoverageRatio;
    HashMap subcontractCoverageRatio = new HashMap();

    public static final int TIMEOUT = 10000;    //prvni nastrel timeoutu...

    /** creates task to manage subcontract to other alliances */
    public CNPTransportSubcontractTask(TransporterAgent owner, CNPTransportBidAnswer primaryContractTask, Collection participants, Proposal primaryContractProposal, TransportCfp fromLocationCfp, int timeout, TeamProposal primaryTeamProposal, Proposal myProposal) {
        super(owner, participants, null, timeout, null, false); //super does not need neither cfpContent (as sendCfp is called in this constructor) nor reason
        this.owner = owner;
        this.primaryContractTask = primaryContractTask;
        this.primaryContractProposal = primaryContractProposal;
        this.fromLocationCfp = fromLocationCfp;
        this.acceptedParticipants = null;
        this.subcontractCfp = prepareSubcontractTransportCfp(fromLocationCfp,primaryContractProposal);
        this.gisShell = owner.gisShell;
        //this.participants = participants;
        this.primaryTeamProposal = primaryTeamProposal;
        this.myProposal = myProposal;
       // this.subcontractCoverageRatio = new HashMap();

        owner.getLogger().info("----- "+owner.getName()+" sending subcontract CFP to: "+((LinkedList)(this.participants)).toString());

        sendCfp(this.subcontractCfp, this.accTimeout, null); //null for reason

    }

    /**
     * prepareSubcontractTransportCfp prepares subcontract - batches from the primary demand (from location) are
     * decreased by the amount of goods covered already within the own alliance
     * @param primaryContractCfp cfp from location
     * @param coveredByOwnAlliProposal proposal with a real coverage - used to prepare new cfp from the cfp sent by a location
     * @return subcontract cfp
     */

    public TransportCfp prepareSubcontractTransportCfp(TransportCfp primaryContractCfp, Proposal coveredByOwnAlliProposal) {


        TransportCfp cfp = new TransportCfp();
        cfp.setRequestid(prepareSubcontractRequestId(primaryContractCfp.getRequestid()));
        cfp.setRequestTime(primaryContractCfp.getRequestTime());

//        long totalPrimaryCount = 0;
//        long totalSubcontractCount = 0;

        HashMap totalPrimaryCounts = new HashMap();
        HashMap totalSubcontractCounts = new HashMap();

        for (Iterator items = coveredByOwnAlliProposal.getItemCoverage().iterator(); items.hasNext(); ) {
            ItemCoverage itemCoverage = (ItemCoverage)items.next();
            for (Iterator tbatches = primaryContractCfp.getTransportBatch().iterator(); tbatches.hasNext() ;) {
                TransportBatch tb = (TransportBatch)tbatches.next();
                if (itemCoverage.getItemid() == tb.getBatchid()) {
                    TransportBatch tbNew = new TransportBatch();
                    tbNew.setBatchid(tb.getBatchid());
                    tbNew.setComodityName(tb.getComodityName());
                    tbNew.setCount(tb.getCount() - (long)Math.floor((tb.getCount()*itemCoverage.getCoverage())));

                    //additioning particular comodity counts from primary contract and from subcontract
                    Long itemPrimaryCount = new Long(tb.getCount());
                    Long itemSubcontractCount = new Long(tb.getCount() - (long)Math.floor((tb.getCount()*itemCoverage.getCoverage())));

                    Long itemTotalPrimaryCount = (Long)totalPrimaryCounts.get(new Long(tb.getBatchid()));
                    if (itemTotalPrimaryCount != null) {
                      itemTotalPrimaryCount = itemTotalPrimaryCount + itemPrimaryCount;
                    }
                    else {
                      totalPrimaryCounts.put(new Long(tb.getBatchid()),itemPrimaryCount);
                    }
                    Long itemTotalSubcontractCount = (Long)totalSubcontractCounts.get(new Long(itemCoverage.getItemid()));
                    if (itemTotalSubcontractCount != null) {
                      itemTotalSubcontractCount = itemTotalSubcontractCount + itemSubcontractCount;
                    }
                    else {
                      totalSubcontractCounts.put(new Long(itemCoverage.getItemid()),itemSubcontractCount);
                    }

//                    totalPrimaryCount += tb.getCount();
//                    totalSubcontractCount += tbNew.getCount();

                    tbNew.setStart(tb.getStart());
                    tbNew.setStartAddress(tb.getStartAddress());
                    tbNew.setTargetAddress(tb.getTargetAddress());
                    tbNew.setTarget(tb.getTarget());
                    tbNew.setStartTime(tb.getStartTime());
                    tbNew.setTargetTime(tb.getTargetTime());
                    cfp.getTransportBatch().add(tbNew);
                    break;
                }
            }
        }

        //calculation of ratios for particular comodity types distighushed by unique itemCoverage IDs
        for (Iterator counts = totalPrimaryCounts.keySet().iterator(); counts.hasNext(); ) {
            Long itemCoverageKey = (Long)counts.next();
            Long thisItemSubcontractCount = (Long)totalSubcontractCounts.get(itemCoverageKey);
            Long thisItemPrimaryCount = (Long)totalPrimaryCounts.get(itemCoverageKey);
            subcontractCoverageRatio.put(itemCoverageKey,new Double((double)thisItemSubcontractCount/(double)thisItemPrimaryCount));
        }

//        this.subcontractCoverageRatio = ((double) totalSubcontractCount / (double) totalPrimaryCount);

        // check if the transport is required or not...
        if (cfp.getTransportBatch().isEmpty())
        {
            return null; // nonsense, should not occure
        }

        return cfp; //returns cfp with modified demand

        //pro kazdy itemID z Proposal najdu tohle v TransportBatchi a odectu item coverage

    }

    /** evaluates offers from other alliances, choose the best, merges proposals and sends proposal to location via CNPTransportBidAnswer method */

    protected List evaluateReplies() {

        // to store the selected offer(s)
        List selected = new LinkedList();
        // to store the best offer so far
        Message bestOffer = null;
        double bestCoverage = 0;// coverage ratio
        long bestPrice = Long.MAX_VALUE;
        // pass through all propositions and check the criteria - price only in our case

        for (Iterator iterator = receivedOffers.values().iterator(); iterator.hasNext();)
        {
            Message m = (Message) iterator.next();


//            owner.getLogger().info("##--## content of message is of type: "+m.getContent().getClass().getName());
              owner.getLogger().info("##--## content of message is of type: "+m.toString());


            if (m.getPerformative().equalsIgnoreCase(MessageConstants.PROPOSAL))
            {
                try
                {
                    Proposal prop = (Proposal) m.getContent();
                    if (null != prop)
                    {
                        long price = prop.getTotalPrice();
                        // coverage is computed as count-weighted coverage of all items
                        double coverage = 0;
                        long total = 0;
                        // go through all batches of the cfp request and compute the coverage
                        for (ListIterator i = subcontractCfp.getTransportBatch().listIterator(); i.hasNext();)
                        {
                            TransportBatch tb = (TransportBatch) i.next();
                            total += tb.getCount();
                            // find corresponding coverage in proposal
                            for (Iterator it = prop.getItemCoverage().iterator(); it.hasNext();)
                            {
                                ItemCoverage ic = (ItemCoverage) it.next();
                                if ( ic.getItemid() == tb.getBatchid())
                                {
                                    coverage += tb.getCount() * ic.getCoverage();
                                    break;
                                }
                            }
                        }

                        if (0 != total) {
                          coverage = coverage / (double)total;
                        }
                        else {
                          coverage = 1; // nothing is allways covered
                        }

                        if ( coverage > bestCoverage || (coverage == bestCoverage && price < bestPrice))
                        {
                            bestOffer = m;
                            bestPrice = price;
                            bestCoverage = coverage;
                        }
                    }
                }
                catch (ClassCastException e)
                {
                    owner.getLogger().severe("Unexpected content type in cfp answer - proposal expected. Message:\n " + m);
                }
            }
        }

        if (null != bestOffer)
        {
            selected.add(bestOffer.getSender());
            // acceptation is assumed as proposal from participant is binding,
            this.bestProposal = (Proposal)bestOffer.getContent();
            //but the registration will be don after the transport is arranged by the proposing party
            // send a winner to topic

          //  gisShell.submitTopic(VisualAgent.TOPIC_LOCATION_WINNER, bestOffer);
          List data = new LinkedList();
          data.add(subcontractCfp);
          data.add(bestOffer.getSender().getName());
          gisShell.submitTopic(VisualAgent.TOPIC_BEST_LEADER, data);

        }

        return selected;

    }


    /**
     * always return true
     */
    protected boolean evaluateAcceptReply(Message m)
    {
        if (m.getPerformative().equalsIgnoreCase(MessageConstants.FAILURE) )
        {

        }
        else if(m.getPerformative().equalsIgnoreCase(MessageConstants.INFORM_DONE) )
        {

        }
        // terminate by returning true
        return true;
    }

    /**
     * This function is called when timeout for accept reply (DONE or FAILURE, ...) elapses.
     */
    protected void evaluateAcceptTimeout()
    {
    }

    protected void handleReplies() {

        // update the status to refuse future messages
        status = STATUS_ACCEPT_SENT;
        // evaluate the replies
        this.acceptedParticipants = evaluateRepliesWithContent();

        System.out.println("@@@@@ accepted subcontract participants - size(): "+this.acceptedParticipants.size());

        //now we merge proposal from the best agent from this.bestProposal and this.primaryContractProposal
        Proposal mergedProposal = null;
        if (bestProposal != null) {
            mergedProposal = this.mergeProposals();
            owner.getLogger().info("----- merging proposals");
            this.primaryContractTask.sendMergedProposal(mergedProposal);

      /*
            List data = new LinkedList();
            data.add(this.primaryContractProposal);     //primary coverage within owners alliance
            data.add(this.fromLocationCfp);             //primary CFP from location
            data.add(this.owner.getName());

            System.out.println("sending primary contract TOPIC");
            owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data);

            List data2 = new LinkedList();
            data2.add(this.bestProposal);                //best subcontract coverage
            data2.add(this.subcontractCfp);              //subcontract cfp
            data2.add(this.owner.getName());

            System.out.println("sending subcontract TOPIC");
            owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data2);
       */ // petr

            List data = new LinkedList();

            data.add(mergedProposal);
            data.add(fromLocationCfp);
            data.add(owner.getName());
            data.add(myProposal);
            data.add(primaryTeamProposal);
            owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data);

        }
        else {
            owner.getLogger().info("----- cannot merge proposals, using primary contract proposal");
            mergedProposal = this.primaryContractProposal;


            List data = new LinkedList();
                   data.add(mergedProposal);
                   data.add(fromLocationCfp);
                   data.add(owner.getName());
                   data.add(myProposal);
                   data.add(primaryTeamProposal);
                   owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data);

            this.primaryContractTask.sendMergedProposal(mergedProposal);

        /*    List data = new LinkedList();
            data.add(this.primaryContractProposal);     //primary coverage within owners alliance
            data.add(this.fromLocationCfp);             //primary CFP from location
            data.add(this.owner.getName());

            System.out.println("sending primary contract TOPIC");
            owner.gisShell.submitTopic(VisualAgent.TOPIC_TEAM_LEADER_PROPOSAL, data); */ // petr

        }
//        this.primaryContractTask.sendMergedProposal(mergedProposal);



    }


    /** sends acceptProposal to the best offer transporter participant in other alliance */
    protected void proposalAcceptedByLocation() {

/*debug*/
        if ((this.acceptedParticipants==null)||(this.acceptedParticipants.isEmpty())) {
            owner.getLogger().info("SUSPITIOUS: participants==null OR no participant of subcontract choosen as the best");
        }

        sendAnswersToParticipants(this.acceptedParticipants); //to the best offer is sent acceptProposal


        // do CNPTransportWithSubcontractTask dodelat submitovani topicu
    }

    /** sends refuseProposal to all transporter participants in other alliance */
    protected void proposalRefusedByLocation() {

        sendAnswersToParticipants(new LinkedHashMap<Address,Object>()); //using empty list, to all participants is sent refuseProposal

        // do CNPTransportWithSubcontractTask dodelat submitovani topicu
    }

    protected Proposal mergeProposals() {

        Proposal mergedProposal = new Proposal();

        mergedProposal.setRequestid(this.primaryContractProposal.getRequestid());

        long mergedProposalPrice = this.primaryContractProposal.getTotalPrice() + this.bestProposal.getTotalPrice();
        long mergedProposalTime = (Math.max(this.primaryContractProposal.getProposalTime(),this.bestProposal.getProposalTime()));

        mergedProposal.setProposalTime(mergedProposalTime);
        mergedProposal.setTotalPrice(mergedProposalPrice);


        //ocheckuj, jestli se tu nesere mergovani, kdyz je bestProposal null!!!!
        //posila se pri refuse od fsech subkontraktantu Proposal locatione???


        //bestProposal byl vzdy null, jaktoze to chodilo a jak???

        if (this.bestProposal != null) {
            owner.getLogger().info("----- subcontract bestProposal ("+owner.getName()+"): "+this.bestProposal.toString());
        }



        for (Iterator ii = this.bestProposal.getItemCoverage().iterator(); ii.hasNext(); ) {
            ItemCoverage subcontractItemCoverage = (ItemCoverage)ii.next();
            boolean itemCoverageFound = false;
            for (Iterator i = this.primaryContractProposal.getItemCoverage().iterator(); i.hasNext(); ) {
                ItemCoverage primaryItemCoverage = (ItemCoverage)i.next();
                if (primaryItemCoverage.getItemid() == subcontractItemCoverage.getItemid()) {
                    itemCoverageFound = true;
                    ItemCoverage newItemCoverage = new ItemCoverage();
                    newItemCoverage.setLocation(primaryItemCoverage.getLocation());
                    newItemCoverage.setItemid(primaryItemCoverage.getItemid());

//                    double itemRatio = ((Double)this.subcontractCoverageRatio.get(new Long(newItemCoverage.getItemid()))).doubleValue();
                    Double itemRatio = (Double)this.subcontractCoverageRatio.get(new Long(newItemCoverage.getItemid()));
                    if (itemRatio != null) {
                      newItemCoverage.setCoverage(primaryItemCoverage.
                                                  getCoverage() +
                                                  itemRatio.doubleValue() *
                                                  subcontractItemCoverage.
                                                  getCoverage());

                      if (newItemCoverage.getCoverage() > 0.8) {
                        System.out.println("BUG 01");
                      }

                    } else {
                      newItemCoverage.setCoverage(primaryItemCoverage.getCoverage());
                      if (newItemCoverage.getCoverage() > 0.8) {
                        System.out.println("BUG 02");
                      }

                      System.out.println("VYPIS");

                    }
                    mergedProposal.getItemCoverage().add(newItemCoverage);
                }

            }
            if (!itemCoverageFound) {
                ItemCoverage newItemCoverage = new ItemCoverage();
                newItemCoverage.setLocation(subcontractItemCoverage.getLocation());
                newItemCoverage.setItemid(subcontractItemCoverage.getItemid());
                newItemCoverage.setCoverage(subcontractItemCoverage.getCoverage());
                mergedProposal.getItemCoverage().add(newItemCoverage);
            }
        }


        for (Iterator i = mergedProposal.getItemCoverage().iterator(); i.hasNext(); ) {
          ItemCoverage ic = (ItemCoverage) i.next();
          if (ic.getCoverage() > 1) {
            System.out.println("BUG");
          }
        }


        return mergedProposal;

    }

    protected String prepareSubcontractRequestId(String primaryContractRequestId) {
        String subcontractRequestId = primaryContractRequestId.concat("-" + owner.getName());
        return subcontractRequestId;
    }
}
