package across.agents.transporter.gui;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import across.agents.transporter.TransporterAgent;
import across.data.AllianceRestrictions;
import across.data.CoalitionLeaderRestrictions;
import across.data.CoalitionRestrictions;
import across.data.ItemCoverage;
import across.data.Param;
import across.data.Possibility;
import across.data.PrivateParams;
import across.data.Proposal;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.util.skn.CommunityKnowledge;
import aglobe.container.Store;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class TransporterAgentGUI extends JFrame {

  private final Store store;
  private static final String STORE_WINDOW_X = "gui/win_x";
  private static final String STORE_WINDOW_Y = "gui/win_y";
  private static final String STORE_WINDOW_WIDTH = "gui/win_width";
  private static final String STORE_WINDOW_HEIGHT = "gui/win_height";

  private final int proposalsInTree = 20;

  private LinkedList proposalNodes = new LinkedList();
  private int proposalsOnScreen = 0;
  private int totalProposals = 0;

  private TransporterAgent owner = null;
  private JTabbedPane jTabbedPane1 = new JTabbedPane();

  private JScrollPane jScrollPane1 = new JScrollPane(); // known service providers
  private JScrollPane jScrollPane2 = new JScrollPane();
  private JScrollPane jScrollPane3 = new JScrollPane();
  private JScrollPane jScrollPane4 = new JScrollPane();
  private JScrollPane jScrollPane5 = new JScrollPane();
  private JScrollPane jScrollPane6 = new JScrollPane();
  private JScrollPane jScrollPaneAlliances = new JScrollPane();
  private JScrollPane coalitionPane = new JScrollPane();


  private DefaultTableModel publicTableModel = new DefaultTableModel();
  private JTable publicTable = new JTable();
  private DefaultTableModel semiTableModel = new DefaultTableModel();
  private JTable semiTable = new JTable();
  private DefaultTableModel privateTableModel = new DefaultTableModel();

//  private MyAlliMembersTableModel membersTableModel;
  private DefaultTreeModel alliTreeModel;
  private DefaultTreeModel myAllianceTreeModel;

  private DefaultTreeModel serviceProvidersTreeModel;




  private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("all");
  private DefaultTreeModel myModel = new DefaultTreeModel(rootNode);
  JTree jTree1 = new JTree();

  JTree jTree3 = new JTree();
  JTree jTree4 = new JTree();
  JTree jTree2 = new JTree();
  JTree jTreeProposals = new JTree();
  JTextArea jTextCoalitions = new JTextArea();

  private Object lock1 = new Object(),lock2 = new Object(),lock3 = new Object();

  private HashMap allPages = new HashMap();


 // JTree jTree2 = new JTree();
 // private DefaultMutableTreeNode pagesRootNode = new DefaultMutableTreeNode("pages - public params");
 // private DefaultTreeModel pagesTreeModel = new DefaultTreeModel(pagesRootNode);





  private DefaultMutableTreeNode proposalsRootNode = new DefaultMutableTreeNode("Proposals");
  private DefaultTreeModel proposalsTreeModel = new DefaultTreeModel(proposalsRootNode);


  public TransporterAgentGUI(TransporterAgent _owner, CommunityKnowledge community) throws HeadlessException {

    owner = _owner;
    store = owner.getContainer().getAgentStore(owner.getName());
    try {
  //    membersTableModel = community.getAlliMembersTableModel();
      alliTreeModel = community.getAlliancesTreeModel();
      myAllianceTreeModel = community.getMyAllianceTreeModel();
      serviceProvidersTreeModel = community.getServiceProvidersTreeModel();

      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {

    jTabbedPane1.setMinimumSize(new Dimension(29, 16));
    jTabbedPane1.setToolTipText("");
    publicTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
    publicTable.setModel(publicTableModel);
    semiTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
    semiTable.setModel(semiTableModel);

    jTree1.setMinimumSize(new Dimension(0, 0));
    jTree1.setModel(null);

    jTreeProposals.setModel(proposalsTreeModel);
    jTreeProposals.expandRow(0);
    jTreeProposals.setRootVisible(false);

    jTree2.setRequestFocusEnabled(true);
    jTree2.setModel(serviceProvidersTreeModel);
    jTree2.expandRow(0);



    jTree3.setRequestFocusEnabled(true);
    jTree3.setModel(alliTreeModel);
    jTree3.expandRow(0);

    jTree4.setRequestFocusEnabled(true);
    jTree4.setModel(myAllianceTreeModel);
    jTree4.expandRow(0);
    jTabbedPane1.add(jScrollPane3, "Public");
    jTabbedPane1.add(jScrollPane4, "Semi");
    jTabbedPane1.add(jScrollPane2, "Private");
    jTabbedPane1.add(jScrollPaneAlliances, "Alliances");
    jTabbedPane1.add(jScrollPane1,   "Known service prowiders");
    jTabbedPane1.add(jScrollPane6, "Alliance members");
    jTabbedPane1.add(jScrollPane5,   "Proposals");
    jScrollPaneAlliances.getViewport().add(jTree3, null);
    jScrollPane6.getViewport().add(jTree4, null);
    jScrollPane1.getViewport().add(jTree2, null);




  //  pagesTreeModel.setRoot(pagesRootNode);
   // jTree2.setModel(pagesTreeModel);

 //   jScrollPane1.getViewport().add(jTree2, null);

    jScrollPane4.getViewport().add(semiTable, null);
    jScrollPane3.getViewport().add(publicTable, null);
    jScrollPane2.getViewport().add(jTree1, null);
    jScrollPane5.getViewport().add(jTreeProposals, null);
    this.getContentPane().add(jTabbedPane1, BorderLayout.CENTER);
    jTabbedPane1.add(coalitionPane, "Coalitions");
    coalitionPane.getViewport().add(jTextCoalitions);
  }



  /**
   * Zobrazi publicParams na zalozce v okne
   * @param pp publicParams
   */
  public void setPublic(final PublicParams pp)
  {
    setPublicTableModel(pp);
  }

  public void setSemi(final SemiPrivateParams spp)
  {
    setSemiTableModel(spp);
  }

  public void setPrivate(final PrivateParams pp)
  {
    setPrivateTableModel(pp);
  }

/*  public void setAllianceMembers(final java.util.List am)
  { synchronized (lock1) {
      int membersCount = am.size();
      final String[] members = new String[membersCount];

      for (int i = 0; i < membersCount; i++) {
        Address adr = (Address) am.get(i);
        members[i] = adr.getName();
      }
      SwingUtilities.invokeLater(new Runnable() {
        public void run() {
           synchronized (lock1) {
            membersTableModel = new DefaultTableModel();
            membersTable.setModel(membersTableModel);
            membersTableModel.addColumn("Members", members);
            membersTable.getColumnModel().getColumn(0).setPreferredWidth(200);
          }
        }
      });
    }

  } */

  /**
   * Zobrazi PublicParams v okne
   * @param pp data k zobrazeni
   */
  private void setPublicTableModel(PublicParams pp)
  {
    synchronized (lock2) {
      java.util.List namesValues = pp.getParam();

      int size = namesValues.size();
      final String[] names = new String[size];
      final String[] values = new String[size];
      for (int i = 0; i < size; i++) {
        Param p = (Param) namesValues.get(i);
        names[i] = p.getName();
        values[i] = p.getValue();
      }

      //zobrazeni
      SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          synchronized (lock2) {
            publicTableModel = new DefaultTableModel();
            publicTable.setModel(publicTableModel);
            publicTableModel.addColumn("PARAMETER", names);
            publicTableModel.addColumn("VALUE", values);
            publicTable.getColumnModel().getColumn(0).setPreferredWidth(100);
            publicTable.getColumnModel().getColumn(1).setPreferredWidth(200);
          }
        }
      });
    }
  }

  /**
   * Zobrazi SemiprivateParams v okne
   * @param spp data k zobrazeni
   */
  private void setSemiTableModel(SemiPrivateParams spp)
  {
    synchronized (lock3) {
      java.util.List semi = spp.getParam();
      java.util.List resource = spp.getResource();

      int size = semi.size() + resource.size();
      final String[] names = new String[size];
      final String[] values = new String[size];

      int j = 0;
      for (Iterator i = semi.iterator(); i.hasNext(); ) {
        Param p = (Param) i.next();
        names[j] = p.getName();
        values[j] = p.getValue();
        j++;
      }
      for (Iterator i = resource.iterator(); i.hasNext(); ) {
        Resource r = (Resource) i.next();
        names[j] = r.getType();
        values[j] = String.valueOf(r.getCapacity());
        j++;
      }

      SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          synchronized (lock3) {
            semiTableModel = new DefaultTableModel();
            semiTable.setModel(semiTableModel);
            semiTableModel.addColumn("PARAMETER", names);
            semiTableModel.addColumn("VALUE", values);
            semiTable.getColumnModel().getColumn(0).setPreferredWidth(100);
            semiTable.getColumnModel().getColumn(1).setPreferredWidth(200);
          }
        }
      });
    }
  }

  /**
   * Method displays tree with restricitions
   * @param pp private data
   */
  private void setPrivateTableModel(PrivateParams pp)
  {
    myModel.setRoot(rootNode);
    jTree1.setModel(myModel);

    DefaultMutableTreeNode restrictionsNode = new DefaultMutableTreeNode("Restrictions");
    rootNode.add(restrictionsNode);

    DefaultMutableTreeNode allianceRestrictionsNode = new DefaultMutableTreeNode("Alliance restrictions");
    restrictionsNode.add(allianceRestrictionsNode);
    DefaultMutableTreeNode coalitionRestrictionsNode = new DefaultMutableTreeNode("Coalition restrictions");
    restrictionsNode.add(coalitionRestrictionsNode);
    DefaultMutableTreeNode coalitionLeaderRestrictionsNode = new DefaultMutableTreeNode("Coalition leader restrictions");
    restrictionsNode.add(coalitionLeaderRestrictionsNode);

    AllianceRestrictions restrictionsA = pp.getAllianceRestrictions();
    addPossibilitiesToTree(allianceRestrictionsNode, restrictionsA.getPossibility());

    CoalitionRestrictions restrictionsC = pp.getCoalitionRestrictions();
    addPossibilitiesToTree(coalitionRestrictionsNode, restrictionsC.getPossibility());

    CoalitionLeaderRestrictions restrictionsL = pp.getCoalitionLeaderRestrictions();
    addPossibilitiesToTree(coalitionLeaderRestrictionsNode, restrictionsL.getPossibility());


    DefaultMutableTreeNode resourcesNode = new DefaultMutableTreeNode("Resources");
    rootNode.add(resourcesNode);
    addResourcesToTree(resourcesNode, pp.getResource());
    jTree1.expandRow(0);
    jTree1.setRootVisible(false);
  }

  private void addResourcesToTree(DefaultMutableTreeNode myRoot, java.util.List resources) {
   for (Iterator i = resources.iterator(); i.hasNext();) {
     Resource r = (Resource)i.next();
     DefaultMutableTreeNode resourceNode = new DefaultMutableTreeNode(r.getType()+" = "+r.getCapacity());
     myRoot.add(resourceNode);
   }
  }

  private void addPossibilitiesToTree(DefaultMutableTreeNode myRoot, java.util.List possibilities) {

    DefaultMutableTreeNode positiveNode = new DefaultMutableTreeNode("positive");
    DefaultMutableTreeNode negativeNode = new DefaultMutableTreeNode("negative");
    myRoot.add(negativeNode);
    myRoot.add(positiveNode);

    for (Iterator i =  possibilities.iterator(); i.hasNext();) {
      Possibility possible = (Possibility)i.next();
      java.util.List positive = possible.getPositive().getParam();
      java.util.List negative = possible.getNegative().getParam();

      for (Iterator j = positive.iterator(); j.hasNext();) {
         Param p = (Param)j.next();
         DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(p.getName()+" = "+p.getValue());
         positiveNode.add(newNode);
      }

      for (Iterator j = negative.iterator(); j.hasNext();) {
         Param p = (Param)j.next();
         DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(p.getName()+" = "+p.getValue());
         negativeNode.add(newNode);
      }
    }

  }

  private void addPublicParamsToTree(DefaultMutableTreeNode myRoot, java.util.List params) {
      for (Iterator j = params.iterator(); j.hasNext();) {
         Param p = (Param)j.next();
         DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(p.getName()+" = "+p.getValue());
         myRoot.add(newNode);
      }
  }


  public void addMyProposal(Proposal proposal) {
    if (proposal != null) {
      totalProposals++;

      DefaultMutableTreeNode newProposalNode = new DefaultMutableTreeNode(
          "my proposal num. " + totalProposals);
      newProposalNode.add(new DefaultMutableTreeNode("Price: " +
          proposal.getTotalPrice()));
      newProposalNode.add(new DefaultMutableTreeNode("Proposal time: " +
          proposal.getProposalTime()));
      newProposalNode.add(new DefaultMutableTreeNode("RequestID: " +
          proposal.getRequestid()));
      DefaultMutableTreeNode newCoverage = new DefaultMutableTreeNode(
          "coverage");
      newProposalNode.add(newCoverage);
      for (Iterator i = proposal.getItemCoverage().iterator(); i.hasNext(); ) {
        ItemCoverage c = (ItemCoverage) i.next();
        DefaultMutableTreeNode coverNode = new DefaultMutableTreeNode(c.
            getItemid() + " = " + c.getCoverage() * 100 + "%");
        newCoverage.add(coverNode);
      }
      proposalsRootNode.add(newProposalNode);
      proposalNodes.addLast(newProposalNode);

      proposalsOnScreen++;
      if (proposalsOnScreen > proposalsInTree) {
        proposalsOnScreen--;
        DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode) proposalNodes.
            getFirst();
        proposalsRootNode.remove(oldNode);
        proposalNodes.removeFirst();
      }
      proposalsTreeModel.reload(proposalsRootNode);
    }
  }

  public void setVisible(boolean parm1) {
    if (!parm1) {
      Point p = getLocation();
      store.putInt(STORE_WINDOW_X, p.x);
      store.putInt(STORE_WINDOW_Y, p.y);

      Dimension d = getSize();
      store.putInt(STORE_WINDOW_WIDTH, d.width);
      store.putInt(STORE_WINDOW_HEIGHT, d.height);
    }
    else {
      if (store.exist(STORE_WINDOW_X)) {
        java.awt.Point loc = getLocation();
        int x = store.getInt(STORE_WINDOW_X, loc.x);
        int y = store.getInt(STORE_WINDOW_Y, loc.y);
        setLocation(x, y);

        Dimension d = getPreferredSize();
        int w = store.getInt(STORE_WINDOW_WIDTH, d.width);
        int h = store.getInt(STORE_WINDOW_HEIGHT, d.height);
        setSize(w, h);
      }
    }

    super.setVisible(parm1);
  }
  public void setRenegade() {
    jTabbedPane1.setBackground(Color.red);
    setTitle(getTitle()+ " - renegade");
  }
  public void setDefaulter() {
    jTabbedPane1.setBackground(Color.blue);
    setTitle(getTitle()+ " - defaluter");
  }
 public void addColaition(String coalition) {
   jTextCoalitions.append(coalition+"\n");
 }


}
