package across.agents.pathfinding.tester;

import across.simulation.constants.AcrossDataConstants;
import aglobe.container.agent.Agent;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;

public class PathfindingTesterAgent extends Agent implements ClientServerTopicConstants, GISTopicListener {

	/** GIS shell */
	protected GISClientService.Shell gisShell;
	
	/** Speed of vehicle in km/h. */
	protected double velocity;         
	  
	/** Consumption in litres/100 km */
	protected double consumption;   
	
	/** Class handling this agent's movement */
	protected PathfindingTesterMovement myMovement = new PathfindingTesterMovement(this);
	
	@Override
	protected void handleIncomingMessage(Message m) {
		// TODO Auto-generated method stub
		logWarning("Unexpected message");
	}

	public void handleTopic(String topic, Object content, String reason) {
		// TODO Auto-generated method stub
		if(topic.equalsIgnoreCase(TOPIC_ENTITY_CONNECTION)) {
			if(content instanceof EntityDescriptor) {
				handleConfiguration((EntityDescriptor) content);
			}
		} 
	}

	@Override
	public void init(AgentInfo ai, int initState) {
		gisShell = (GISClientService.Shell) this.getContainer().getServiceManager().getService(this, GISClientService.SERVICENAME);
		if(gisShell!=null) {
			gisShell.subscribeTopic(TOPIC_ENTITY_CONNECTION, this);
		} else {
			logSevere("Unable to locate GIS!");
			this.stop();
		}
	}
	
	protected void handleConfiguration(EntityDescriptor ed) {
  	    this.velocity = Double.parseDouble(ed.confParamsString.get(AcrossDataConstants.VEHICLE_VELOCITY));
  	    this.consumption = Double.parseDouble(ed.confParamsString.get(AcrossDataConstants.VEHICLE_CONSUMPTION));

  	    myMovement.handleConfiguration(ed, velocity, consumption);
       
        
        String visioInfo = "<b>" + this.getName();
        gisShell.submitTopicToServer(across.visio.oldvisio.VisioConnectionAgent.TOPIC_VISIO_INFO, visioInfo);
	}
	
	
	
}
