package across.agents.location.util;

import java.util.ArrayList;
import java.util.List;

import across.agents.location.LocationAgent;
import across.data.Batch;
import across.data.Param;
import aglobex.simulation.ontology.entity.EntityDescriptor;

public class LocationUtils {
	
	/**
	 * Gets the parameters relevant to the generators from the entity's configuration
	 * @param ed
	 * @return
	 */
	public static final List<Param> getGeneratorParams(EntityDescriptor ed) {
		List<Param> ret = new ArrayList<Param>();
		for (String key : ed.confParamsString.keySet()) {
			Param param = new Param();
			param.setName(key);
			param.setValue(ed.confParamsString.get(key));
			if(key.indexOf("mine")!=-1 || key.indexOf("population")!=-1 || key.indexOf("bakery")!=-1) {
				if(Integer.parseInt(param.getValue())!=0) {
					ret.add(param);
				}
			}
		}
		return ret;
	}
	
	/**
	 * Prepares batches for CNP request. This version creates a batch for one
	 * commodity.
	 *
	 * @param commodity commodity to acquire
	 * @param quantity quantity to demand
	 * @return across.data.Batch
	 */
	public static Batch prepareGoodsCFPContent(LocationAgent ag, String commodity, long quantity) {
		Batch b = new Batch();
		b.setBatchid((System.currentTimeMillis()%(ag.getAddress().hashCode()*ag.getCurrentTime()))*commodity.hashCode()*quantity);
		b.setCount((int)quantity);
		b.setComodityName(commodity);
		b.setDeliveryTime(System.currentTimeMillis()+100);
		return b;
	}
	/**
	 * Same as prepareGoodsCFPContent, but also uses String requestId for new batchId.
	 * @param commodity
	 * @param quantity
	 * @param requestId
	 * @return
	 */
	public static Batch prepareNewRequestGoodsCFPContent(LocationAgent ag, String commodity, long quantity, String requestId) {
		Batch b = new Batch();
		b.setBatchid((System.currentTimeMillis()%(ag.getAddress().hashCode()*requestId.hashCode()))*commodity.hashCode()*quantity);
		b.setCount((int)quantity);
		b.setComodityName(commodity);
		b.setDeliveryTime(System.currentTimeMillis()+100);
		return b;
	}
}
