package across.agents.location.task;

import across.agents.location.LocationAgent;
import across.data.Batch;
import aglobe.container.agent.CMAgent;
import aglobe.ontology.Message;
import aglobex.protocol.subscribe.SubscribeParticipantTask;

// TODO - doc
abstract public class LocSubscribeParticipantTask extends SubscribeParticipantTask {
		
    public static final int LOCTASK_DRIVER = 1;
    
    private int type = 0;
	
	  /**
	   * prepare fipa subscribe protocol - participant part task
	   *
	   * @param owner CMAgent
	   * @param subscribeMessage Message
	   * @param autostart boolean
	   */
	  public LocSubscribeParticipantTask (CMAgent owner, Message subscribeMessage, int type, boolean autostart) {
	      super(owner, subscribeMessage, autostart);
	      this.type = type;
	  }
	  
	  abstract protected void processSubscribe(Message subscribeMessage);
	  
	  public void timeout(Batch batch){
		  // XXX - config - get the requested fill property from configuration or from owner agent.
		  int requestedFill = 1;
		  Double successRate = ((LocationAgent)owner).books.goodsUnload(batch, requestedFill, false); 
		  System.out.println(owner.getName()+" TIMEOUT SUBSCRIBE, SENDING FAILURE successrate: "+successRate);
		  switch (type) {
		  case LOCTASK_DRIVER:
			  failure(successRate,LocIdleTask.LOC_TIMEOUT);
			  break;
		  }
	  }
	  
	  public void goodsDelivered(Batch batch, Long id) {
			switch (type) {
			case LOCTASK_DRIVER:
				// XXX - config - get the requested fill property from configuration or from owner agent.
				 int requestedFill = 1;
				double succesRate = ((LocationAgent)owner).books.goodsUnload( (Batch) subscribeMessage.getContent(),requestedFill, false);
				informResult(succesRate);
				break;
			}
	  }
}