/*
 * NewTransportRequestGUI.java
 *
 * Created on 15. listopad 2004, 15:59
 */
package across.agents.location.gui;

import across.agents.location.LocationAgent;
import across.agents.location.util.LocationUtils;
import across.data.RequestList;

/**
 *
 * @author  biba
 */
public class NewTransportRequestGUI extends javax.swing.JDialog {

    String requestId;
    LocationAgent owner;
    private final String DEFUALT_COMMODITY_AMOUNTS = "2500";

    /** Creates new form NewTransportRequestGUI */
    public NewTransportRequestGUI(java.awt.Frame parent, boolean modal, String requestId, LocationAgent owner) {
        super(parent, modal);
        this.requestId = requestId;
        this.owner = owner;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JTextArea jTextArea1;

        this.setLocation(this.getParent().getLocation());

        jLabel1 = new javax.swing.JLabel();
        jTextArea1 = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        jTextArea2 = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jButton3 = new javax.swing.JButton();
        jTextField1 = new javax.swing.JTextField();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("New Transport Request");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setModal(true);
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setLabelFor(jTextArea1);
        jLabel1.setText("Request ID: ");
        jLabel1.setDebugGraphicsOptions(javax.swing.DebugGraphics.NONE_OPTION);
        jLabel1.setMaximumSize(new java.awt.Dimension(94, 15));
        jLabel1.setMinimumSize(new java.awt.Dimension(94, 15));
        jLabel1.setPreferredSize(new java.awt.Dimension(94, 15));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jLabel1, gridBagConstraints);

        jTextArea1.setText(this.requestId);
        jTextArea1.setBackground(javax.swing.UIManager.getDefaults().getColor("Button.background"));
        jTextArea1.setEditable(false);
        jTextArea1.setFont(new java.awt.Font("Dialog", 2, 12));
        jTextArea1.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(153, 153, 153)));
        jTextArea1.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jTextArea1.setMaximumSize(new java.awt.Dimension(100, 16));
        jTextArea1.setMinimumSize(new java.awt.Dimension(100, 16));
        jTextArea1.setName("requestId");
        jTextArea1.setPreferredSize(new java.awt.Dimension(100, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jTextArea1, gridBagConstraints);

        jLabel2.setText("Request Time: ");
        jLabel2.setMaximumSize(new java.awt.Dimension(94, 15));
        jLabel2.setMinimumSize(new java.awt.Dimension(94, 15));
        jLabel2.setPreferredSize(new java.awt.Dimension(94, 15));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jLabel2, gridBagConstraints);
        jLabel2.getAccessibleContext().setAccessibleName("Request Time:");

        jTextArea2.setBackground(javax.swing.UIManager.getDefaults().getColor("Button.background"));
        jTextArea2.setEditable(false);
        jTextArea2.setFont(new java.awt.Font("Dialog", 2, 12));
        jTextArea2.setText("(current time)");
        jTextArea2.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(153, 153, 153)));
        jTextArea2.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jTextArea2.setMaximumSize(new java.awt.Dimension(100, 16));
        jTextArea2.setMinimumSize(new java.awt.Dimension(100, 16));
        jTextArea2.setName("requestTime");
        jTextArea2.setPreferredSize(new java.awt.Dimension(100, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jTextArea2, gridBagConstraints);

        jButton1.setText("Cancel");
        jButton1.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jButton1.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cancelRequest(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jButton1, gridBagConstraints);

        jButton2.setText("Send request");
        jButton2.setMaximumSize(new java.awt.Dimension(120, 25));
        jButton2.setMinimumSize(new java.awt.Dimension(120, 25));
        jButton2.setName("sendRequest");
        jButton2.setPreferredSize(new java.awt.Dimension(120, 25));
        jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                sendRequest(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jButton2, gridBagConstraints);

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        jScrollPane1.setMaximumSize(new java.awt.Dimension(200, 110));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(200, 110));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(200, 110));
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, ""},
                {null, ""},
                {null, ""},
                {null, ""},
                {null, ""},
                {null, ""}
            },
            new String [] {
                "commodity", "amount"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, true
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTable1.setMaximumSize(new java.awt.Dimension(200, 110));
        jTable1.setMinimumSize(new java.awt.Dimension(200, 110));
        jTable1.setPreferredSize(new java.awt.Dimension(200, 110));
        jTable1.setModel(new NewRequestTableModel());
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jButton3.setText("Set all to:");
        jButton3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                setAllAmountsTo(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jButton3, gridBagConstraints);

        jTextField1.setPreferredSize(new java.awt.Dimension(100, 16));
        jTextField1.setText(this.DEFUALT_COMMODITY_AMOUNTS);
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setAllAmountsToEnterPressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(jTextField1, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void setAllAmountsToEnterPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setAllAmountsToEnterPressed
        // TODO add your handling code here:
/*        
        try {
            String text = jTextField1.getText();
            try {
                if (Long.valueOf(text).longValue() < 0) {
                    jTextField1.setText(this.DEFUALT_COMMODITY_AMOUNTS);
                }
            }
            catch (NumberFormatException ee) {
                jTextField1.setText(this.DEFUALT_COMMODITY_AMOUNTS);
            }
        }
        catch (NullPointerException e) {
        }
*/
    }//GEN-LAST:event_setAllAmountsToEnterPressed

    private void setAllAmountsTo(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_setAllAmountsTo
        // TODO add your handling code here:
        try {
            String text = jTextField1.getText();
            try {
                if (Long.valueOf(text).longValue() >= 0) {
                    for (int i=0; i<6; i++) {
                        jTable1.setValueAt(text,i,1);
                    }
                }
                else {
                    jTextField1.setText(this.DEFUALT_COMMODITY_AMOUNTS);
                }
            }
            catch (NumberFormatException ee) {
                jTextField1.setText(this.DEFUALT_COMMODITY_AMOUNTS);
            }
        }
        catch (NullPointerException e) {
        }
    }

    private void sendRequest(java.awt.event.MouseEvent evt) {
        final RequestList newRequest = new RequestList();
        newRequest.setDeliveryLocation(owner.getContainer().getContainerName());
        newRequest.setDeliveryAddress(owner.getAddress());
        newRequest.setRequestid(this.requestId);
        newRequest.setRequestTime((owner.getCurrentTime() > 0) ? owner.getCurrentTime() : 1); //avoiding zero or negative requestTime
        for (int row = 0;row<6;row++) {
                if (Long.valueOf((String)jTable1.getValueAt(row,1)).longValue() > 0) {
                    newRequest.getBatch().add(LocationUtils.prepareNewRequestGoodsCFPContent(owner,(String)jTable1.getValueAt(row,0),Long.valueOf((String)jTable1.getValueAt(row,1)).longValue(),this.requestId));
                }
        }
        
        if (newRequest.getBatch().size()>0) {
            owner.addEvent(new Runnable() {
              public void run() {
                owner.startManualRequest(newRequest);
              }
            });
        }
        else {
        }

        dispose();
    }

    private void cancelRequest(java.awt.event.MouseEvent evt) {
        dispose();
    }


    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextArea jTextArea2;
    private javax.swing.JTextField jTextField1;

}
