/*
 * NewRequestTableModel.java
 *
 * Created on 16. listopad 2004, 15:50
 */

package across.agents.location.gui;

import javax.swing.table.AbstractTableModel;

import across.util.GoodsConstants;

/**
 *
 * @author  biba
 */
public class NewRequestTableModel  extends AbstractTableModel {
  
  private final int columns = 2;
  private String[][] data = new String[columns][6];

  public NewRequestTableModel() {
    String[] comodities = {GoodsConstants.BREAD,GoodsConstants.FISH,GoodsConstants.FLOUR,GoodsConstants.GRAIN,GoodsConstants.SHEEP,GoodsConstants.WATER};
    String[] amounts = {"0","0","0","0","0","0"};
    putColumn(0,comodities);
    putColumn(1,amounts);
    fireTableDataChanged();
  }   
  
  public Object getValueAt(int row, int column) {
    return data[column][row];
  }

  public void setValueAt(Object aValue, int row, int column) {
    try {
      //Integer.valueOf((String)aValue).toString();
      data[column][row] = Long.valueOf((String)aValue).toString();        
    }
    catch (NumberFormatException e) {
      data[column][row] = "0";        
    }
    fireTableCellUpdated(row, column);
  }
  
  
  public int getRowCount() {
    return 6;
  }

  public int getColumnCount() {
    return columns;
  }
  public void putColumn(int column, String[] d)  {
    for (int i=0;i<d.length;i++) {
      data[column][i] = d[i];
    }
  }

  public String getColumnName(int c) {
    if (c == 0) {
      return "commodity";
    }
    if (c == 1) {
      return "amount";
    }
   return null;
  }    
  
  boolean[] canEdit = new boolean [] {false, true};

  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return canEdit[columnIndex];
  }
}
