package across.agents.location.generator;

import java.util.List;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.data.Param;

/**
 * Created by IntelliJ IDEA.
 * User: rehakm1
 * Date: 26.5.2004
 * Time: 16:07:59
 * To change this template use Options | File Templates.
 */
/**
 * This interface shall be implemented by entities wishing to act as a resource consumer and/or generator in the Location entity.
 */
public abstract class Generator
{
    /**
     * This method is called by location to demand resource generation or consumption.
     * Current stock/offer/demand/... available on the location is passes in the books variable.
     * Current weather is passed in as weather parameter.
     * @param weather Current weather
     * @param books Object with current goods/requests/supply/demand status
     * @return parameter characterizing the generator - popSize for population, actual capacity for mine, nominalCapacity for bakery
     */
    public abstract long generationStep(Object weather, StockOfferDemand books, SimulationObjectsEffects effects);

    /** Creates the list of generators using the information in agent params - if not available, default set is used */
    public static void initGenerators(List<Param> params, List<Generator> generators)  {
        // start the generators - try to load config from params
    	for (Param param : params) {
            if (PopulationGenerator.NAME.equalsIgnoreCase(param.getName())) {
                if (Integer.parseInt(param.getValue()) > 0) {
                    generators.add( new PopulationGenerator(Integer.parseInt(param.getValue())));
                }
            } else if (param.getName().startsWith(MineGenerator.NAME))  {
                if (Integer.parseInt(param.getValue()) > 0) {
                    String com = param.getName().substring(MineGenerator.NAME.length());
                    generators.add( new MineGenerator(com,Integer.parseInt(param.getValue())));
                }
            } else if (BakeryGenerator.NAME.equalsIgnoreCase(param.getName())) {
                if (Integer.parseInt(param.getValue()) > 0) {
                    generators.add( new BakeryGenerator(Integer.parseInt(param.getValue())));
                }
            }
        }
        // check if there are some generators. if not, include default values.
        if ( 0 == generators.size()) {
            generators.add( new PopulationGenerator(2000));
            generators.add( new MineGenerator(across.util.GoodsConstants.WATER, 10000));
            generators.add( new MineGenerator(across.util.GoodsConstants.GRAIN, 1000));
            generators.add( new MineGenerator(across.util.GoodsConstants.FISH, 100));
            generators.add( new BakeryGenerator(5000));
        }
    }
}
