package across.agents.emergency.planner;

import iglobe.plan.OrderConstraint;
import iglobe.plan.PlanConstraint;
import iglobe.plan.RescueActivity;
import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import iglobe.plan.TransportActivity;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import across.simulation.constants.AcrossTopicConstants;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.protocol.request.RequestParticipantTask;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.sensor.UniversalSensorAgent;

/**
 * This agent holds the IX planner that is able to produce rescue plans
 * for the disasters.
 * @author Eduard Semsch
 *
 */
public class IXPlannerAgent extends CMAgent implements ClientServerTopicConstants, GISTopicListener {

	/** Type of this agent by which it is known at the directory service. */
	public static final String TYPE = "IXPlanner";
	
	/** GIS shell. */
	protected GISClientService.Shell gisShell;
	
	/** Directory service shell. */
	protected DirectoryService.Shell dirShell;
	
	@Override
	public void init(AgentInfo ai, int initState) {
		gisShell = (GISClientService.Shell) this.getContainer().getServiceManager().getService(this, GISClientService.SERVICENAME);
		dirShell = (DirectoryService.Shell) this.getContainer().getServiceManager().getService(this, DirectoryService.SERVICENAME);
		if(gisShell!=null && dirShell!=null) {
			gisShell.subscribeTopic(TOPIC_ENTITY_CONNECTION, this);
			gisShell.subscribeTopic(TOPIC_ENTITY_CONTROL, this);
			gisShell.subscribeTopic(TOPIC_SIMULATION_TIME_UPDATE_1_SECOND, this);
			gisShell.subscribeTopic(UniversalSensorAgent.TOPIC_SENSORY_DATA,this);
			gisShell.subscribeTopic(AcrossTopicConstants.TOPIC_SIMULATION_OBJECT, this);
		} else {
			logSevere("Unable to locate GIS!");
			this.stop();
		}
		try {
			dirShell.register(this, new LinkedList<String>(Arrays.asList(new String[]{TYPE})));
		} catch (DirectoryException e) {
			e.printStackTrace();
		}
		this.setIdleTask(new IXPlannerIdleTask(this));
	}
	
	/**
	 * Agents idle task - handles new incoming messages that 
	 * does not have known conversation ids.
	 * @author Eduard Semsch
	 *
	 */
	protected class IXPlannerIdleTask extends Task implements MessageConstants {

		public IXPlannerIdleTask(ConversationUnit cu) {
			super(cu);
		}

		/**
		 * This method handles all the incoming messages that does not have
		 * known conversation ids. 
		 */
		@Override
		protected void handleIncomingMessage(Message m) {
			final Object content = m.getContent();
			if(m.getPerformative().equalsIgnoreCase(REQUEST) && content instanceof RescueTask) {
				new RequestParticipantTask(this, m) {

					@Override
					protected void processRequest(Message requestMessage) {
						RescueTask rt = (RescueTask) content;
						RescuePlan rp = new RescuePlan();
						List<RescueActivity> raList = new LinkedList<RescueActivity>();
						List<PlanConstraint> pcList = new LinkedList<PlanConstraint>();
						
						// repair
						TransportActivity taGoToPlace = new TransportActivity();
						taGoToPlace.setId("1");
						taGoToPlace.setDestination(rt.getLocation());
						taGoToPlace.setDescription("TRANSPORT");
						taGoToPlace.setResource("Repair");
						TransportActivity taUseEffect = new TransportActivity();
						taUseEffect.setId("2");
						taUseEffect.setDestination(rt.getLocation());
						taUseEffect.setDescription("EFFECT");
						taUseEffect.setResource("Repair");
						raList.add(taGoToPlace);
						raList.add(taUseEffect);
						
						// ambulance
						TransportActivity taGoToPlaceAmb = new TransportActivity();
						taGoToPlaceAmb.setId("4");
						taGoToPlaceAmb.setDestination(rt.getLocation());
						taGoToPlaceAmb.setDescription("TRANSPORT");
						taGoToPlaceAmb.setResource("Ambulance");
						TransportActivity taHeal = new TransportActivity();
						taHeal.setId("5");
						taHeal.setDestination(rt.getLocation());
						taHeal.setDescription("EFFECT");
						taHeal.setResource("Ambulance");
						raList.add(taGoToPlaceAmb);
						raList.add(taHeal);
						
						OrderConstraint pc12 = new OrderConstraint();
						pc12.setFromId(taGoToPlace.getId());
						pc12.setToId(taUseEffect.getId());
						pcList.add(pc12);
						
						OrderConstraint pc45 = new OrderConstraint();
						pc45.setFromId(taGoToPlaceAmb.getId());
						pc45.setToId(taHeal.getId());
						pcList.add(pc45);
						
						OrderConstraint pc25 = new OrderConstraint();
						pc25.setFromId(taUseEffect.getId());
						pc25.setToId(taHeal.getId());
						pcList.add(pc25);
						
						rp.setActivities(raList);
						rp.setConstraints(pcList);
						
						informResult(rp);
					}
					
				};
			}
			
		}
		
	}
	
	/**
	 * This method handles the incoming topics from the simulation.
	 */
	public void handleTopic(String topic, Object content, String reason) {
		if(topic.equalsIgnoreCase(TOPIC_ENTITY_CONNECTION)) {
			if(content instanceof EntityDescriptor) {
				handleConfiguration((EntityDescriptor) content);
			}
		}
	}
	
	/**
	 * This method handles configuration.
	 * @param ed
	 */
	private void handleConfiguration(EntityDescriptor ed) {
		
	}
}
