package across.agents.emergency.centre;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class represents a plan that is schedulable/executable in ACROSS
 * simulation scenario.
 * @author Eduard Semsch
 *
 */
public class AcrossPlan {

	/** 
	 * Map driver ID <-> driver type.  The driver ID is not an ID of a 
	 * certain driver in the simulation - it is the ID of the driver
	 * throughout the plan.
	 */  
	protected Map<String,String> drivers = new HashMap<String, String>();
	
	/** 
	 * Map material ID <-> material type.  The material ID is not an ID of a 
	 * certain portion of material in the simulation - it is the ID of the material
	 * throughout the plan.
	 */
	protected Map<String,String> material = new HashMap<String, String>();
	
	/** Map activity <-> driver. */
	protected Map<AcrossActivity,String> activitiesHandlers = new HashMap<AcrossActivity, String>();
	
	/** Precedences map succeeding activity <-> list of preceeding activities. */ 
	protected Map<AcrossActivity,List<AcrossActivity>> precedences = new HashMap<AcrossActivity, List<AcrossActivity>>();

	public Map<AcrossActivity, String> getActivitiesHandlers() {
		return activitiesHandlers;
	}

	public void setActivitiesHandlers(Map<AcrossActivity, String> activitiesHandlers) {
		this.activitiesHandlers = activitiesHandlers;
	}

	public Map<String, String> getDrivers() {
		return drivers;
	}

	public void setDrivers(Map<String, String> drivers) {
		this.drivers = drivers;
	}

	public Map<String, String> getMaterial() {
		return material;
	}

	public void setMaterial(Map<String, String> material) {
		this.material = material;
	}

	public Map<AcrossActivity, List<AcrossActivity>> getPrecedences() {
		return precedences;
	}

	public void setPrecedences(Map<AcrossActivity, List<AcrossActivity>> precedences) {
		this.precedences = precedences;
	}
	
}
