package across.agents.emergency.centre;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import across.agents.emergency.repair.RepairVehicleActivities;

/**
 * This class represents an atomic activity in ACROSS simulation
 * scenario.
 * @author Eduard Semsch
 *
 */
public class AcrossActivity implements Serializable {

	/** Type of the activity. */
	protected String activityType;
	
	/** Necessary parameters for the activity. */
	protected Map<String,Object> params = new HashMap<String,Object>();

	public AcrossActivity() {
		
	}
	
	public AcrossActivity(String activityType) {
		this.activityType = activityType; 
	}
	
	/**
	 * States of an activity.  These are the possible states the activity
	 * can be in. 
	 * @author Eduard Semsch
	 *
	 */
	public static enum ActivityState {
		WAITING,
		EXECUTING,
		DONE,
		FAILED;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public Map<String, Object> getParams() {
		return params;
	}

	public void setParams(Map<String, Object> params) {
		this.params = params;
	}
	
	public void replaceStringInParams(String what, String byWhat) {
		for (String k : params.keySet()) {
			Object o = params.get(k);
			if(o instanceof String) {
				String str = (String) o;
				if(str.equals(what)) {
					params.put(k, byWhat);
				}
			}
		}
	}
	
	@Override
	public String toString() {
		if(activityType.equals(RepairVehicleActivities.ACTIVITY_GOTO)) {
			if(params.get("OBJECT")!=null) {
				return "Going to: "+params.get("OBJECT");
			} else {
				return "Going to: "+params.get("TO");
			}
		} else if(activityType.equals(RepairVehicleActivities.ACTIVITY_EFFECT)) {
			return "Working";
		} else if(activityType.equals(RepairVehicleActivities.ACTIVITY_DROP)) {
			return "Dropping: "+params.get("AMOUNT")+" "+params.get("MATERIAL_ID");
		} else if(activityType.equals(RepairVehicleActivities.ACTIVITY_PICKUP)) {
			return "Picking up: "+params.get("AMOUNT")+" "+params.get("MATERIAL_ID");
		}
		return null;
	}
	
}
