package across.agents.driver.util;

import across.agents.driver.DriverAgent;
import aglobe.container.EventReceiver;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.transport.Address;


  /**
   * Class for looking up the driver's transporter - it tries periodically (with the help of 
   * resendMessages method in DriverAgent) to locate it via the DirectoryService.
   */
  public class UpdateTransporter implements DirectoryListener {
	  
    private final EventReceiver owner;
    
    private Address myTransporter;

	public UpdateTransporter(EventReceiver owner, Address myTransporter) {
	  this.owner = owner;
	  this.myTransporter = myTransporter;
	}
	
	/**
	 * Not implemented.
	 */
	public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {}
	
	/**
	 * Not implemented.
	 */
	public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {}
	
	/**
	 * Not implemented.
	 */
	public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter){}
	
	/**
	 * Not implemented.
	 */
	public void handleTopic(String topic, Object content, String reason){}
	
	/**
	 * This method is called when a new transporter becomes visible.  If this driver's transporter 
	 * is among the visible ones this method calls the method resendMessages from the DriverAgent
	 * to deliver all the undelivered messages to the transporter.
	 */
	public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter){
	  for (int i = 0; i < records.length; i++) {
	    DirectoryRecord record = records[i];
	    if (record.address == myTransporter) {
	    	((DriverAgent)owner).resendMessages();
	    }
	  }
	}
	
	public void addEvent(Runnable e) {
	  owner.addEvent(e);
	}
  }
