package across.agents.driver.data;

import java.util.LinkedList;
import java.util.List;

import across.data.Waypoint;

/**
 * Route = sequence of waypoints.
 * @author Eduard Semsch
 *
 */
public class Route{
  RouteInfo routeInfo;
  LinkedList<Waypoint> waypoints = new LinkedList<Waypoint>();

  public Route(){}

  public void addWaypoint(Waypoint wp){
    waypoints.add(wp);
  }

  public void addWaypoints(List<Waypoint> waypoints) {
	  this.waypoints.addAll(waypoints);
  }
  
  public List<Waypoint> getWaypoints(){
    return waypoints;
  }

  public RouteInfo getRouteInfo() {
	return routeInfo;
  }

  public void setRouteInfo(RouteInfo routeInfo) {
	 this.routeInfo = routeInfo;
  }

  public String toString(){
    return "ArcValue: " + routeInfo.routePrice + " " + routeInfo.routeTime + "\n" + "intermNodes:" + waypoints;
  }
}
