;;; Test version of an I-Globe domain

(annotations
  (search-preference = :depth-first))

(refinement deal-with-accident-with-injury
	    (deal-with-accident ?number-injured ?location)
  (variables ?number-injured ?location
	     ?medical ?security ?transport)
  (nodes
    (1 (transport 1 ?medical ?location))
    (2 (transport 1 ?security ?location))
    (3 (transport 1 ?transport ?location))
    (4 (transport ?number-injured injured-person hospital)))
  (orderings
    ((1 2 3) 4))
  (constraints
    (compute multiple-answer
      (identity (doctor paramedic))
      = ?medical)
    (compute multiple-answer
      (identity (police-team))
      = ?security)
    (compute multiple-answer
      (identity (ambulance truck))
      = ?transport)))

(refinement transport-doctor (transport ?n doctor ?location)
  (variables ?n ?location)
  (constraints
    (resource consume (doctor) = ?n)))

(refinement transport-paramedic (transport ?n paramedic ?location)
  (variables ?n ?location)
  (constraints
    (resource consume (paramedic) = ?n)))

(refinement transport-police-team (transport ?n police-team ?location)
  (variables ?n ?location)
  (constraints
    (resource consume (police-team) = ?n)))

(refinement transport-ambulance (transport ?n ambulance ?location)
  (variables ?n ?location)
  (constraints
    (resource consume (ambulance) = ?n)))

(refinement transport-truck (transport ?n truck ?location)
  (variables ?n ?location)
  (constraints
    (resource consume (truck) = ?n)))

(refinement transport-injured-person (transport ?n injured-person ?location)
  (variables ?n ?location)
  (constraints
    (resource consume (injured-person) = ?n)))

;;; End
