/*
 * Decompiled with CFR 0.152.
 */
package ix.iglobe.test;

import aglobe.container.agent.Agent;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import ix.iglobe.test.shared.IGlobeCallback;
import ix.iglobe.test.shared.IGlobeIXAgent;
import ix.util.ColorGenerator;
import ix.util.Debug;
import ix.util.Strings;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Random;

public class RescuePlanner
extends Agent
implements MessageConstants {
    static ColorGenerator colorGen = new ColorGenerator();
    protected IGlobeIXAgent ixAgent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AgentInfo agentInfo, int n) {
        super.init(agentInfo, n);
        this.logger.fine("Test Rescue Planner started");
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("domain-library/phase1.lsp");
        String[] stringArray = colorGen;
        synchronized (colorGen) {
            int n2 = colorGen.nextRGB();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            stringArray = new String[]{"-domain=" + uRL, "-step-limit=500", "-background-color=0x" + Integer.toHexString(n2)};
            try {
                this.ixAgent = this.startSeparateAgent("ix.iglobe.test.IGlobeIp2", stringArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return;
        }
    }

    protected void handleIncomingMessage(Message message) {
        System.out.println("Message: " + message);
    }

    IGlobeIXAgent startSeparateAgent(String string, String[] stringArray) throws Exception {
        URL uRL = this.jarURL("iglobe.jar");
        URL uRL2 = this.jarURL("ix.jar");
        URL[] uRLArray = new URL[]{uRL, uRL2};
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        IXAgentClassLoader iXAgentClassLoader = new IXAgentClassLoader(uRLArray, classLoader);
        Class<?> clazz = ((ClassLoader)iXAgentClassLoader).loadClass(string);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        IGlobeIXAgent iGlobeIXAgent = (IGlobeIXAgent)constructor.newInstance(new Object[0]);
        Class[] classArray = new Class[]{stringArray.getClass()};
        Method method = clazz.getMethod("mainStartup", classArray);
        method.invoke((Object)iGlobeIXAgent, new Object[]{stringArray});
        iGlobeIXAgent.setIGlobeCallback(new IGLobeServices());
        return iGlobeIXAgent;
    }

    URL jarURL(String string) throws MalformedURLException {
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        String string4 = System.getProperty("file.separator");
        for (String string5 : Strings.breakAt((String)string3, (String)string2)) {
            String string6 = Strings.afterLast((String)string4, (String)string5);
            if (!string6.equals(string)) continue;
            Debug.noteln((String)"Found jar", (Object)string5);
            return new File(string5).toURL();
        }
        throw new IllegalStateException("Can't find " + string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TaskGenerator {
        Random random = new Random();
        String[] locations = new String[]{"London", "Edinburgh", "Prague"};
        int minInjured = 1;
        int maxInjured = 3;

        TaskGenerator() {
        }

        RescueTask nextTask() {
            RescueTask rescueTask = new RescueTask();
            rescueTask.setLocation(this.randomth(this.locations));
            rescueTask.setNumberInjured(this.between(this.minInjured, this.maxInjured));
            return rescueTask;
        }

        private <T> T randomth(T ... TArray) {
            return TArray[this.random.nextInt(TArray.length)];
        }

        private int between(int n, int n2) {
            int n3 = n2 - n;
            return n + this.random.nextInt(n3 + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IGLobeServices
    implements IGlobeCallback {
        TaskGenerator taskGenerator = new TaskGenerator();

        IGLobeServices() {
        }

        @Override
        public void generateTask() {
            RescuePlanner.this.ixAgent.newTask(this.taskGenerator.nextTask());
        }

        @Override
        public void generateTask(List<String> list) {
            RescueTask rescueTask = this.taskGenerator.nextTask();
            rescueTask.setUnavailableResources(list);
            RescuePlanner.this.ixAgent.newTask(rescueTask);
        }

        @Override
        public void takePlan(RescuePlan rescuePlan, RescueTask rescueTask) {
            Debug.noteln((String)"Received a plan for", (Object)rescueTask);
            RescuePlanner.this.ixAgent.viewPlan(rescuePlan);
        }

        @Override
        public void noPlan(RescueTask rescueTask) {
            Debug.noteln((String)"No plan for", (Object)rescueTask);
        }

        @Override
        public void exit() {
            RescuePlanner.this.kill();
        }
    }

    public static class IXAgentClassLoader
    extends URLClassLoader {
        public IXAgentClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.loadClass(string, false);
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (this.isSharedClass(string)) {
                return super.loadClass(string, bl);
            }
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                clazz = this.findClass(string);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        boolean isSharedClass(String string) {
            return !string.startsWith("ix.") || string.indexOf(".shared.") > 0;
        }
    }
}

