/*
 * Decompiled with CFR 0.152.
 */
package ix.iglobe.test;

import iglobe.plan.AbstractActivity;
import iglobe.plan.OrderConstraint;
import iglobe.plan.PlanConstraint;
import iglobe.plan.RescueActivity;
import iglobe.plan.RescuePlan;
import iglobe.plan.TransportActivity;
import ix.icore.Variable;
import ix.icore.domain.End;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.Ip2;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RescuePlanMaker {
    protected Ip2 ip2;
    protected ActivityItem root;
    protected List<RescueActivity> activities = new LinkedList<RescueActivity>();
    protected List<PlanConstraint> constraints = new LinkedList<PlanConstraint>();
    protected Map<ActivityItem, RescueActivity> activityTranslation = new LinkedHashMap<ActivityItem, RescueActivity>();
    Gensym.Generator nameGen = new Gensym.Generator();

    public RescuePlanMaker(Ip2 ip2, ActivityItem activityItem) {
        this.ip2 = ip2;
        this.root = activityItem;
    }

    public RescuePlan makeRescuePlan() {
        RescuePlan rescuePlan = new RescuePlan();
        this.createRescueActivities();
        this.collectConstraints();
        if (!this.activities.isEmpty()) {
            rescuePlan.setActivities(this.activities);
        }
        if (!this.constraints.isEmpty()) {
            rescuePlan.setConstraints(this.constraints);
        }
        return rescuePlan;
    }

    void createRescueActivities() {
        this.mapActivityTree(this.root, "activity");
    }

    void mapActivityTree(ActivityItem activityItem, String string) {
        String string2 = this.nameGen.nextString(string);
        RescueActivity rescueActivity = this.makeRescueActivity(activityItem, string2);
        Debug.noteln((String)"ACT", (Object)rescueActivity);
        this.activities.add(rescueActivity);
        this.activityTranslation.put(activityItem, rescueActivity);
        for (ActivityItem activityItem2 : activityItem.getChildren()) {
            this.mapActivityTree(activityItem2, string2);
        }
    }

    RescueActivity makeRescueActivity(ActivityItem activityItem, String string) {
        LList lList = (LList)Variable.removeVars((Object)activityItem.getPattern());
        String string2 = Lisp.elementsToString((LList)lList);
        String string3 = lList.get(0).toString();
        RescueActivity rescueActivity = string3.equals("transport") ? this.makeTransportActivity(lList) : new AbstractActivity();
        rescueActivity.setId(string);
        rescueActivity.setDescription(string2);
        return rescueActivity;
    }

    TransportActivity makeTransportActivity(LList lList) {
        TransportActivity transportActivity = new TransportActivity();
        LList lList2 = Lisp.elementsFromString((String)"transport ?number ?resource ?location");
        MatchEnv matchEnv = SimpleMatcher.mustMatch((Object)lList2, (Object)lList);
        Long l = (Long)this.matchValue(matchEnv, "?number", Long.class);
        Symbol symbol = (Symbol)this.matchValue(matchEnv, "?resource", Symbol.class);
        Symbol symbol2 = (Symbol)this.matchValue(matchEnv, "?location", Symbol.class);
        transportActivity.setAmount(l.intValue());
        transportActivity.setResource(symbol.toString());
        transportActivity.setDestination(symbol2.toString());
        return transportActivity;
    }

    Object matchValue(MatchEnv matchEnv, String string, Class clazz) {
        Object object = matchEnv.get((Object)Symbol.intern((String)string));
        return Util.mustBe((Class)clazz, (Object)object);
    }

    void collectConstraints() {
        for (Map.Entry<ActivityItem, RescueActivity> entry : this.activityTranslation.entrySet()) {
            ActivityItem activityItem = entry.getKey();
            RescueActivity rescueActivity = entry.getValue();
            PNodeEnd pNodeEnd = activityItem.getBegin();
            for (PNodeEnd pNodeEnd2 : pNodeEnd.getPredecessors()) {
                ActivityItem activityItem2;
                if (pNodeEnd2.getEnd() != End.END || !(activityItem2 = (ActivityItem)pNodeEnd2.getNode()).isDescendentOf((PNode)this.root)) continue;
                RescueActivity rescueActivity2 = this.activityTranslation.get(activityItem2);
                Debug.expect((rescueActivity2 != null ? 1 : 0) != 0, (String)"Can't find", (Object)activityItem2);
                OrderConstraint orderConstraint = new OrderConstraint();
                orderConstraint.setFromId(rescueActivity2.getId());
                orderConstraint.setToId(rescueActivity.getId());
                this.constraints.add(orderConstraint);
            }
        }
    }
}

