/*
 * Decompiled with CFR 0.152.
 */
package ix.iglobe.test;

import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.process.PNode;
import ix.iface.util.IFUtil;
import ix.iglobe.test.RescuePlanMaker;
import ix.iglobe.test.shared.IGlobeCallback;
import ix.iglobe.test.shared.IGlobeIXAgent;
import ix.ip2.AbstractAgendaItemPopupMenu;
import ix.ip2.ActivityItem;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2Frame;
import ix.ip2.NewIp2Frame;
import ix.iplan.IPlanOptionManager;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import ix.util.xml.XMLTreeViewFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGlobeIp2
extends Ip2
implements IGlobeIXAgent {
    IGlobeCallback callback;
    boolean handleAutomatically = false;
    Map<Name, RescueTask> activityIdToTask = new LinkedHashMap<Name, RescueTask>();
    XMLTreeViewFrame treeViewer = new XMLTreeViewFrame((IXAgent)this, "Rescue Plan");

    public IGlobeIp2() {
        this.logoLine1 = "I-Globe I-X Process Panel";
        this.logoImage = "ip2-logo.gif";
    }

    public static void main(String[] stringArray) {
        Util.printGreeting((String)"I-Globe I-P2");
        new IGlobeIp2().mainStartup(stringArray);
    }

    @Override
    public void setIGlobeCallback(IGlobeCallback iGlobeCallback) {
        this.callback = iGlobeCallback;
    }

    @Override
    public void newTask(RescueTask rescueTask) {
        Debug.noteln((String)"New rescue task", (Object)rescueTask);
        Symbol symbol = Symbol.intern((String)"deal-with-accident");
        Symbol symbol2 = Symbol.intern((String)rescueTask.getLocation());
        int n = rescueTask.getNumberInjured();
        Cons cons = Lisp.list((Object)symbol, (Object)new Long(n), (Object)symbol2);
        Activity activity = new Activity((LList)cons);
        activity.ensureId();
        this.activityIdToTask.put(activity.getId(), rescueTask);
        ActivityItem activityItem = this.controller.addActivity(activity);
        activityItem.setIsNew(true);
        List<String> list = rescueTask.getUnavailableResources();
        if (list != null) {
            List<Constraint> list2 = this.makeUnavailableResourceConstraints(list);
            this.getIp2ModelManager().addConstraints((PNode)activityItem, list2);
        }
        if (this.handleAutomatically) {
            this.planFor(activityItem, rescueTask);
        }
    }

    @Override
    public void schedulingFailure(RescueTask rescueTask) {
        Debug.noteln((String)"Scheduling failure for", (Object)rescueTask);
        this.newTask(rescueTask);
    }

    @Override
    public void viewPlan(RescuePlan rescuePlan) {
        this.treeViewer.editObject((Object)rescuePlan);
        this.treeViewer.setVisible(true);
    }

    public void exit() {
        this.frame.dispose();
        this.callback.exit();
    }

    List<Constraint> makeUnavailableResourceConstraints(List<String> list) {
        LinkedList<Constraint> linkedList = new LinkedList<Constraint>();
        for (String string : list) {
            PatternAssignment patternAssignment = new PatternAssignment((LList)Lisp.list((Object)Symbol.intern((String)string)), (Object)new Long(0L));
            Constraint constraint = new Constraint("resource", "overall", (List)Lisp.list((Object)patternAssignment));
            linkedList.add(constraint);
        }
        return linkedList;
    }

    void planFor(ActivityItem activityItem, RescueTask rescueTask) {
        IPlanOptionManager iPlanOptionManager = this.getOptionManager();
        if (!iPlanOptionManager.plan()) {
            this.callback.noPlan(rescueTask);
            return;
        }
        Name name = activityItem.getAbout().getId();
        ActivityItem activityItem2 = (ActivityItem)this.controller.getActivityAgenda().getItem(name);
        RescuePlanMaker rescuePlanMaker = new RescuePlanMaker(this, activityItem2);
        RescuePlan rescuePlan = rescuePlanMaker.makeRescuePlan();
        this.callback.takePlan(rescuePlan, rescueTask);
    }

    protected Ip2Frame makeIp2Frame() {
        ModifiedIp2Frame modifiedIp2Frame = new ModifiedIp2Frame(this);
        int n = Parameters.getInt((String)"background-color", (int)0);
        if (n != 0) {
            Color color = new Color(n);
            JComponent jComponent = (JComponent)modifiedIp2Frame.getContentPane();
            jComponent.setBorder(BorderFactory.createLineBorder(color, 3));
        }
        modifiedIp2Frame.addTest("Generate rescue task", new ActionListener((Ip2Frame)modifiedIp2Frame){
            final /* synthetic */ Ip2Frame val$frame;
            {
                this.val$frame = ip2Frame;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog((Component)this.val$frame, (Object)"Enter unavailable resources separated by commas");
                if (string == null) {
                    return;
                }
                if (string.equals("")) {
                    IGlobeIp2.this.callback.generateTask();
                } else {
                    IGlobeIp2.this.callback.generateTask(Strings.breakAt((String)",", (String)string));
                }
            }
        });
        modifiedIp2Frame.addTest("Set to automatic", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                if (string.endsWith("automatic")) {
                    IGlobeIp2.this.handleAutomatically = true;
                    abstractButton.setText("Set to manual");
                } else if (string.endsWith("manual")) {
                    IGlobeIp2.this.handleAutomatically = false;
                    abstractButton.setText("Set to automatic");
                } else {
                    throw new ConsistencyException("Invalid test action", (Object)string);
                }
            }
        });
        return modifiedIp2Frame;
    }

    class SendNoPlanHandler
    implements ActionListener {
        ActivityItem item;

        SendNoPlanHandler(ActivityItem activityItem) {
            this.item = activityItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RescueTask rescueTask = IGlobeIp2.this.activityIdToTask.get(this.item.getAbout().getId());
            IGlobeIp2.this.callback.noPlan(rescueTask);
        }
    }

    class SendSubtreeHandler
    implements ActionListener {
        ActivityItem item;

        SendSubtreeHandler(ActivityItem activityItem) {
            this.item = activityItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RescuePlanMaker rescuePlanMaker = new RescuePlanMaker(IGlobeIp2.this, this.item);
            RescuePlan rescuePlan = rescuePlanMaker.makeRescuePlan();
            Debug.noteln((String)"Plan", (Object)XML.objectToXMLString((Object)rescuePlan));
            RescueTask rescueTask = IGlobeIp2.this.activityIdToTask.get(this.item.getAbout().getId());
            IGlobeIp2.this.callback.takePlan(rescuePlan, rescueTask);
        }
    }

    class ModifiedIp2Frame
    extends NewIp2Frame {
        ModifiedIp2Frame(Ip2 ip2) {
            super(ip2);
        }

        public void adjustAgendaItemPopup(AbstractAgendaItemPopupMenu abstractAgendaItemPopupMenu, AgendaItem agendaItem) {
            if (agendaItem.getLevel() == 0 && agendaItem instanceof ActivityItem) {
                JMenuItem jMenuItem;
                if (!agendaItem.getChildren().isEmpty()) {
                    jMenuItem = IFUtil.makeMenuItem((String)"Send to HUMRED", (ActionListener)new SendSubtreeHandler((ActivityItem)agendaItem));
                    abstractAgendaItemPopupMenu.add(jMenuItem);
                }
                jMenuItem = IFUtil.makeMenuItem((String)"Tell HUMRED no plan was found", (ActionListener)new SendNoPlanHandler((ActivityItem)agendaItem));
                abstractAgendaItemPopupMenu.add(jMenuItem);
            }
        }
    }
}

