/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.DoesNotReifyException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;

public class ReifiedStatementImpl
extends ResourceImpl
implements ReifiedStatement {
    protected Statement statement;
    public static final Implementation reifiedStatementFactory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            Triple triple = this.getTriple(enhGraph, node);
            if (triple == null) {
                throw new DoesNotReifyException(node);
            }
            Statement statement = StatementImpl.toStatement(triple, enhGraph);
            return new ReifiedStatementImpl(enhGraph, node, statement);
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return this.getTriple(enhGraph, node) != null;
        }

        private Triple getTriple(EnhGraph enhGraph, Node node) {
            return enhGraph.asGraph().getReifier().getTriple(node);
        }
    };

    private ReifiedStatementImpl(Model model, String string, Statement statement) {
        super(string, model);
        this.assertStatement(statement);
    }

    protected ReifiedStatementImpl(EnhGraph enhGraph, Node node, Statement statement) {
        super(node, enhGraph);
        this.assertStatement(statement);
    }

    private void assertStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    protected Reifier getReifier() {
        return this.getModel().getGraph().getReifier();
    }

    public boolean isValid() {
        return this.getModel().getGraph().getReifier().getTriple(this.asNode()) != null;
    }

    private ReifiedStatementImpl cache() {
        this.getReifier().reifyAs(this.asNode(), this.statement.asTriple());
        return this;
    }

    public static ReifiedStatement create(Statement statement) {
        return ReifiedStatementImpl.create(statement.getModel(), null, statement);
    }

    public static ReifiedStatementImpl create(Model model, String string, Statement statement) {
        return new ReifiedStatementImpl(model, string, statement).cache();
    }

    public static ReifiedStatementImpl create(EnhGraph enhGraph, Node node, Statement statement) {
        return new ReifiedStatementImpl(enhGraph, node, statement).cache();
    }

    public String toString() {
        return super.toString() + "=>" + this.statement;
    }
}

