/*
 * Decompiled with CFR 0.152.
 */
package jtp.util;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class SwingConsole
extends JTextPane {
    private int inputStart = 0;
    private Writer out = new ConsoleWriter();
    MutableAttributeSet INPUT_ATTS;
    PipedWriter toPipe;
    PipedReader fromPipe;

    public SwingConsole() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() < SwingConsole.this.inputStart) {
                    SwingConsole.this.inputStart += documentEvent.getLength();
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() < SwingConsole.this.inputStart) {
                    if (documentEvent.getOffset() + documentEvent.getLength() > SwingConsole.this.inputStart) {
                        SwingConsole.this.inputStart = documentEvent.getOffset();
                    } else {
                        SwingConsole.this.inputStart -= documentEvent.getLength();
                    }
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.INPUT_ATTS = new SimpleAttributeSet();
        StyleConstants.setBold(this.INPUT_ATTS, true);
        this.toPipe = new PipedWriter();
        try {
            this.fromPipe = new PipedReader(this.toPipe);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == '\n') {
            try {
                String string = this.getDocument().getText(this.inputStart, this.getDocument().getLength() - this.inputStart);
                this.toPipe.write(string);
                this.toPipe.flush();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.inputStart = this.getDocument().getLength();
        }
    }

    public Writer getWriter() {
        return this.out;
    }

    public Reader getReader() {
        return this.fromPipe;
    }

    class ConsoleWriter
    extends Writer {
        ConsoleWriter() {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            try {
                SwingConsole.this.getDocument().insertString(SwingConsole.this.getDocument().getLength(), new String(cArray, n, n2), SimpleAttributeSet.EMPTY);
                SwingConsole.this.inputStart = SwingConsole.this.getDocument().getLength();
                SwingConsole.this.setCaretPosition(SwingConsole.this.inputStart);
                SwingConsole.this.setCharacterAttributes(SwingConsole.this.INPUT_ATTS, true);
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(badLocationException.toString());
            }
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

