/*
 * Decompiled with CFR 0.152.
 */
package jtp.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReplacementHashSet
extends AbstractSet {
    Object[] table;
    int capacity;
    int size = 0;

    public ReplacementHashSet(int n) {
        this.capacity = n;
        this.table = new Object[n];
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new RHSIterator();
    }

    public boolean contains(Object object) {
        Object object2 = this.table[this.getSlot(object)];
        return object2 != null && object2.equals(object);
    }

    public boolean remove(Object object) {
        int n = this.getSlot(object);
        Object object2 = this.table[n];
        if (object2 != null && object2.equals(object)) {
            this.table[n] = null;
            --this.size;
            return true;
        }
        return false;
    }

    public boolean add(Object object) {
        int n = this.getSlot(object);
        if (this.table[n] != null) {
            if (this.table[n].equals(object)) {
                return false;
            }
            this.table[n] = object;
            return true;
        }
        this.table[n] = object;
        ++this.size;
        return true;
    }

    public int getSlot(Object object) {
        int n = object.hashCode() % this.capacity;
        if (n < 0) {
            n += this.capacity;
        }
        return n;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Object getObjectAtSlot(int n) {
        return this.table[n];
    }

    class RHSIterator
    implements Iterator {
        int n = 0;

        RHSIterator() {
        }

        public boolean hasNext() {
            while (this.n < ReplacementHashSet.this.capacity) {
                if (ReplacementHashSet.this.table[this.n] == null) {
                    ++this.n;
                    continue;
                }
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ReplacementHashSet.this.table[this.n++];
        }

        public void remove() {
            while (--this.n >= 0) {
                if (ReplacementHashSet.this.table[this.n] == null) continue;
                ReplacementHashSet.this.table[this.n] = null;
                --ReplacementHashSet.this.size;
                return;
            }
            throw new IllegalStateException();
        }
    }
}

